% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_targeting_nodes.R
\name{find_targeting_nodes}
\alias{find_targeting_nodes}
\title{Finds potential affecting node for given particular target.}
\usage{
find_targeting_nodes(
  input_graph,
  how = 2,
  cycle = 1,
  limit = 0,
  fast = 0,
  top = 5,
  target = NULL
)
}
\arguments{
\item{input_graph}{The graph object that was processed with priming_graph function.}

\item{how}{The change of count (expression) of the given node in terms of fold change.}

\item{cycle}{The iteration of simulation.}

\item{limit}{The minimum fold change which can be taken into account for
perturbation calculation on all nodes in terms of percentage.}

\item{fast}{specifies percentage of affected target in target expression.
For example, if fast = 1, the nodes that are affected from miRNA repression
activity more than one percent of their expression is determined as subgraph.}

\item{top}{Determines how many nodes most affected will be evaluated.}

\item{target}{The target node in which is being investigated.}
}
\value{
It gives a tibble form dataset that includes parturbation node (source) and
change in count of targeting node
}
\description{
Finds potential affecting node for given particular target.
}
\details{
Lists potential targeting nodes by running 
find_affected_nodes function for all nodes in network.
}
\examples{

data('midsamp')

midsamp\%>\%
priming_graph(competing_count = Gene_expression, 
              miRNA_count = miRNA_expression)\%>\%
find_targeting_nodes(how = 2, 
                     cycle = 2, 
                     target = "Gene1", 
                     top = 2)


}
