% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{normalize_count}
\alias{normalize_count}
\title{Normalize count data}
\usage{
normalize_count(object)
}
\arguments{
\item{object}{\code{scNMFSet} object.}
}
\value{
\code{scNMFSet} object with normalized count data.
}
\description{
Rescale count matrix entries such that all cells have the same library size.
}
\details{
For analysis purposes, it is sometimes useful to rescale integer count
data into floats such that all cells have the same median counts. 
This function will calculate the median of all UMI counts of cells (total
number of RNAs derived from each cell). All count data are then rescaled
such that cells have uniform UMI count equal to the median.
}
\examples{
library(Matrix)
set.seed(1)
s <- scNMFSet(count=matrix(rpois(n=1200,lambda=3),40,30))
colMeans(counts(s))
s <- normalize_count(s)
colMeans(counts(s))
}
