% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scNMF_class.R
\name{coeff}
\alias{coeff}
\title{Coefficient matrices in an Object}
\usage{
coeff(object)
}
\arguments{
\item{object}{Object of class \code{scNMFSet}.}
}
\value{
Either \code{NULL} or a list of same length as 
\code{ranks(object)}, whose
elements are coefficient matrices derived from factorization 
under each rank value.
}
\description{
Retrieve or set the coefficient matrices from factorization in an 
object
}
\details{
After factorization, coefficient matrices \code{H} corresponding 
to each rank value are
stored as elements of a list, which is in slot \code{coeff} of object of
class \code{scNMFSet}.
\code{coeff(object)} will return the list of matrices. 
\code{coeff(object) <- value}
can be used to modify it.
}
\examples{
s <- scNMFSet(count=matrix(rpois(n=12,lambda=3),4,3))
s <- vb_factorize(s,ranks=seq(2,4))
coeff(s)[[1]]
}
