% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{assignCelltype}
\alias{assignCelltype}
\title{Cell type assignment via GSEA}
\usage{
assignCelltype(obj, rank, gset, gene_names = NULL, p = 0,
  remove.na = FALSE, p.value = FALSE, nperm = 1000,
  progress.bar = TRUE, grp.prefix = c("IG"))
}
\arguments{
\item{obj}{Object of class \code{scNMFSet}.}

\item{rank}{Rank to examine}

\item{gset}{List of gene sets to be used as markers}

\item{gene_names}{Names of genes to be used for meta-gene identification}

\item{p}{Enrichment score exponent.}

\item{remove.na}{Remove gene sets with no overlap}

\item{p.value}{Estimatte p values using permutation}

\item{nperm}{No. of permutation replicates}

\item{progress.bar}{Display progress bar for p value computation}

\item{grp.prefix}{Gene name prefix to search for with wildcard matches in query}
}
\value{
Matrix of enrichment score statistics with cell types in rows and
        clusters in columns
}
\description{
Computes GSEA enrichment score of marker sets in meta gene list
}
\details{
If \code{obj} is of clas \code{scNMFSet}, it computes meta gene list using
\code{\link{meta_gene.cv}}. Otherwise, \code{obj} is expected to be 
a data frame of the same structure as the output of \code{meta_gene.cv};
the number of rows same as the total number of metagenes per cluster, 
three columns per each cluster (gene name, meta-gene score, and coefficient of variation).
The argument \code{gset} is a list of gene sets to be checked for enrichment in 
each cluster meta gene list. The enrichment score is computed using 
the GSEA algorithm \insertCite{subramanian_etal}{ccfindR}.
}
\examples{
dir <- system.file('extdata',package='ccfindR')
pbmc <- read_10x(dir)
pbmc <- vb_factorize(pbmc, ranks=5)
meta <- meta_gene.cv(pbmc,rank=5, gene_names=rowData(pbmc)[,2])
markers <- list('B cell'=c('CD74','IG','HLA'),
                'CD8+ T'=c('CD8A','CD8B','GZMK','CCR7','LTB'),
                'CD4+ T'=c('CD3D','CD3E','IL7R','LEF1'),
                'NK'=c('GNLY','NKG7','GZMA','GZMH'),
                'Macrophage'=c('S100A8','S100A9','CD14','LYZ','CFD'))
gsea <- assignCelltype(meta, rank=5, gset=markers, grp.prefix=c('IG','HLA'))
gsea
}
\references{
\insertRef{subramanian_etal}{ccfindR}
}
