% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{getOntology}
\alias{getOntology}
\title{Obtain the EFO and UBERON ontology}
\usage{
getOntology(onto = c("efo", "uberon"), cache = TRUE)
}
\arguments{
\item{onto}{character. Ontology to obtain. Should be either \code{"efo"} (default)
to obtain the Experimental Factor Ontology (EFO) or \code{"uberon"} to obtain
the Uber-anatomy ontology (UBERON).}

\item{cache}{logical. Should a locally cached version used if available?
Defaults to \code{TRUE}.}
}
\value{
An object of class \code{ontology_index} as defined in the
ontologyIndex package.
}
\description{
Lightweight wrapper around \code{ontologyIndex::get_ontology}
to parse the Experimental Factor Ontology (EFO) or the Uber-anatomy ontology
(UBERON) from OBO format into an R object.
}
\examples{

 uberon <- getOntology("uberon")

}
\references{
EFO: \url{https://www.ebi.ac.uk/ols/ontologies/efo}

 UBERON: \url{https://www.ebi.ac.uk/ols/ontologies/uberon}
}
\seealso{
\code{get_ontology} from the ontologyIndex package.
}
