% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportUCSC.R
\name{breakpointr2UCSC}
\alias{breakpointr2UCSC}
\title{Export UCSC browser formated files}
\usage{
breakpointr2UCSC(
  index,
  outputDirectory,
  fragments = NULL,
  deltaWs = NULL,
  breakTrack = NULL,
  confidenceIntervals = NULL,
  breaksGraph = NULL
)
}
\arguments{
\item{index}{A character used to name the bedfile(s).}

\item{outputDirectory}{Location to write bedfile(s).}

\item{fragments}{A \code{\link{GRanges-class}} object with strand and mapq metadata, such as that generated by \code{\link{readBamFileAsGRanges}}}

\item{deltaWs}{A \code{\link{GRanges-class}} object with metadata column "deltaW" generated by \code{\link{deltaWCalculator}}.}

\item{breakTrack}{A \code{\link{GRanges-class}} object with metadata "genoT" (e.g. newBreaks) will write a bedtrack with refined breakpoints.}

\item{confidenceIntervals}{A \code{\link{GRanges-class}} object with metadata "genoT" the same length as \code{breakTrack} (e.g. confint) will write a bedtrack with breakpoints confidence intervals.}

\item{breaksGraph}{A \code{\link{GRanges-class}} object.}
}
\value{
\code{NULL}
}
\description{
Write a bedfile or bedgraph from a breakpointR object for upload on to the UCSC Genome browser.
}
\examples{
## Get an example file
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
exampleFile <- list.files(exampleFolder, full.names=TRUE)[1]
## Load the file 
brkpts <- get(load(exampleFile))
## Write results to BED files
breakpointr2UCSC(index='testfile', outputDirectory=tempdir(), breakTrack=brkpts$breaks)
}
\author{
Ashley Sanders, David Porubsky, Aaron Taudt
}
