% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{epiNEM2Bg}
\alias{epiNEM2Bg}
\title{Switch between epiNEM and B-NEM}
\usage{
epiNEM2Bg(t)
}
\arguments{
\item{t}{full epiNEM model}
}
\value{
differential effects pattern
}
\description{
Convert epiNEM model into general Boolean graph.
Only needed for comparing accuracy of inferred network for bnem and epiNEM.
}
\examples{
topology <- epiNEM::CreateTopology(3, 1, force = TRUE)
topology <- unlist(unique(topology), recursive = FALSE)
extTopology <- epiNEM::ExtendTopology(topology$model, 100)
b <- epiNEM2Bg(extTopology)
}
\seealso{
CreateTopology
}
\author{
Martin Pirkl
}
