% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{computeFc}
\alias{computeFc}
\title{Compute differential effects}
\usage{
computeFc(CNOlist, y)
}
\arguments{
\item{CNOlist}{CNOlist object (see package CellNOptR), if available.}

\item{y}{activation pattern according to the annotation in CNOlist}
}
\value{
numeric matrix with annotated response scheme
}
\description{
computes differential effects given an activation pattern
(absolute gene expression or truth table)
}
\examples{
sifMatrix <- rbind(c("A", 1, "B"), c("A", 1, "C"), c("B", 1, "D"),
c("C", 1, "D"))
temp.file <- tempfile(pattern="interaction",fileext=".sif")
write.table(sifMatrix, file = temp.file, sep = "\t",
row.names = FALSE, col.names = FALSE,
quote = FALSE)
PKN <- CellNOptR::readSIF(temp.file)
CNOlist <- dummyCNOlist("A", c("B","C","D"), maxStim = 1, maxInhibit = 2,
signals = c("A", "B","C","D"))
model <- CellNOptR::preprocessing(CNOlist, PKN, maxInputsPerGate = 100)
expression <- matrix(rnorm(nrow(slot(CNOlist, "cues"))*10), 10,
nrow(slot(CNOlist, "cues")))
fc <- computeFc(CNOlist, expression)
}
\author{
Martin Pirkl
}
