% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{deva_results}
\alias{deva_results}
\title{Utility function that allows easier grabbing of data}
\usage{
deva_results(deva_out, ID = NULL, type = NULL)
}
\arguments{
\item{deva_out}{output from the deva function}

\item{ID}{The keyword to search through analyses and grab desired output}

\item{type}{<"table" | "heatmap" | "fraction_table" | "median" | "boundary">
to return the desirted analysis type}
}
\value{
desired subset of analysis from deva
}
\description{
Utility function that allows easier grabbing of data
}
\examples{

suppressPackageStartupMessages(library(SummarizedExperiment))
data("sample_phosphodata")
data("sample_annotationdata")

se = SummarizedExperiment(
    assays = list(counts = as.matrix(sample_phosphodata[1:1000,])),
    colData = DataFrame(sample_annotationdata))

deva_out = deva(se = se,
    analyze_negative_outliers = FALSE, aggregate_features = TRUE,
    feature_delineator = "-", fraction_samples_cutoff = 0.3,
    fdrcutoffvalue = 0.1)

deva_results(deva_out, ID = "outlieranalysis", type = "table")
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
