% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{deva_normalization}
\alias{deva_normalization}
\title{Normalization of data to prepare for deva. Uses a Median of Ratio method
followed by a log2 transformation.}
\usage{
deva_normalization(intable, method = "MoR-log")
}
\arguments{
\item{intable}{table with samples along the columns and features along the
rows.}

\item{method}{DEFAULT: "MoR-log"; Method by which to normalize data in
preparation for deva. Options are <"MoR-log", "MoR", "log">. Where "MoR"
refers to the Median of ratio's. The "log" transformation is necessary
to compress heavily skewed data and allow for proper detection.
"MoR-log" as the default will perform MoR followed by a log2 transform.}
}
\value{
A normalized table for input into deva
}
\description{
Normalization of data to prepare for deva. Uses a Median of Ratio method
followed by a log2 transformation.
}
\examples{
library(pasilla)
pasCts <- system.file("extdata",
    "pasilla_gene_counts.tsv", package="pasilla")
cts <- as.matrix(read.csv(pasCts,sep="\\t",row.names="gene_id"))
norm_cts <- deva_normalization(cts, method = "MoR-log")
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
