% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot,biosign,ANY-method}
\alias{plot,biosign,ANY-method}
\alias{plot.biosign}
\alias{plot,biosign-method}
\alias{plot,biosignMultiDataSet,ANY-method}
\alias{plot.biosignMultiDataSet}
\alias{plot,biosignMultiDataSet-method}
\title{Plot method for 'biosign' signature objects}
\usage{
\S4method{plot}{biosign,ANY}(
  x,
  y,
  tierMaxC = "S",
  typeC = c("tier", "boxplot")[1],
  plotSubC = "",
  fig.pdfC = c("none", "interactive", "myfile.pdf")[2],
  info.txtC = c("none", "interactive", "myfile.txt")[2]
)

\S4method{plot}{biosignMultiDataSet,ANY}(
  x,
  y,
  tierMaxC = "S",
  typeC = c("tier", "boxplot")[1],
  plotSubC = "",
  fig.pdfC = c("none", "interactive", "myfile.pdf")[2],
  info.txtC = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{biosign}, created by the \code{biosign}
function.}

\item{y}{Currently not used.}

\item{tierMaxC}{Character: Maximum level of tiers to display: Either 'S' and
'A', (for boxplot), or also 'B', 'C', 'D', and 'E' (for tiers) by decreasing
number of selections}

\item{typeC}{Character: Plot type; either 'tier' [default] displaying the
comparison of signatures up to the selected 'tierMaxC' or 'boxplot' showing
the individual boxplots of the features selected by all the classifiers}

\item{plotSubC}{Character: Graphic subtitle}

\item{fig.pdfC}{Character: File name with '.pdf' extension for the figure;
if 'interactive' (default), figures will be displayed interactively; if 'none',
no figure will be generated}

\item{info.txtC}{Character: File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\value{
A plot is created on the current graphics device.
}
\description{
Displays classifier tiers or individual boxplots from selected features

This function plots signatures obtained by \code{biosign}.
}
\examples{

## loading the diaplasma dataset

data(diaplasma)
attach(diaplasma)

## restricting to a smaller dataset for this example

featureSelVl <- variableMetadata[, "mzmed"] >= 490 & variableMetadata[, "mzmed"] < 500
dataMatrix <- dataMatrix[, featureSelVl]
variableMetadata <- variableMetadata[featureSelVl, ]

## signature selection for all 3 classifiers
## a bootI = 5 number of bootstraps is used for this example
## we recommend to keep the default bootI = 50 value for your analyzes

diaSign <- biosign(dataMatrix, sampleMetadata[, "type"], bootI = 5)

## individual boxplot of the selected signatures

plot(diaSign, typeC = "boxplot")

detach(diaplasma)

data("NCI60", package = "ropls")
nci.mds <- NCI60[["mds"]]

# Restricting to the "agilent" and "hgu95" datasets

nci.mds <- nci.mds[, c("agilent", "hgu95")]

# Restricting to the 'ME' and 'LE' cancer types

library(Biobase)
sample_names.vc <- Biobase::sampleNames(nci.mds[["agilent"]])
cancer_type.vc <- Biobase::pData(nci.mds[["agilent"]])[, "cancer"]
nci.mds <- nci.mds[sample_names.vc[cancer_type.vc \%in\% c("ME", "LE")], ]

# Selecting the significant features for PLS-DA, RF, and SVM classifiers

nci_cancer.biosign <- biosign(nci.mds, "cancer", bootI = 5)
# Plotting the selected signatures
plot(nci_cancer.biosign)
}
\author{
Philippe Rinaudo and Etienne Thevenot (CEA)
}
