test_that("@longtests captures tests", {
  out <- roxygen2::roc_proc_text(longtests_roclet(), "
    #' @longtests
    #' expect_equal(2, 2)
    #'
    NULL")
  expect_equal(length(out), 1)
  expect_equal(length(out$longtests), 1)

  out <- out$longtests[[1]]

  # # Generated by biocroxytest: do not edit by hand!
  #
  # # <text>
  #
  # test_that("[unknown alias] @ L4", {
  #   NULL
  # })

  expect_match(out, "^# Generated by biocroxytest: do not edit by hand!")
  expect_match(out, '# <text>', fixed = TRUE)
  expect_match(out, "expect_equal(2, 2)", fixed = TRUE)
})

test_that("All good @longtests", {
  out <- roxygen2::roc_proc_text(longtests_roclet(), "
    #' Summing two numbers
    #'
    #' @param x A number
    #' @param y Another number
    #'
    #' @longtests
    #' expect_equal(f(0, 0), 0)
    #' expect_equal(f(2, 3), 5)
    f <- function(x, y) {
      x + y
    }")

  expect_equal(length(out), 1)
  expect_equal(length(out$longtests), 1)

  out <- out$longtests[[1]]

  # # Generated by biocroxytest: do not edit by hand!
  #
  # # <text>
  #
  # test_that("Function f() @ L10", {
  #   expect_equal(f(0, 0), 0)
  #   expect_equal(f(2, 3), 5)
  # })

  expect_match(out, "^# Generated by biocroxytest: do not edit by hand!")
  expect_match(out, '# <text>', fixed = TRUE)
  expect_match(
    out,
    'test_that(\"Function f() @ L10\", {\n  expect_equal(f(0, 0), 0)\n  expect_equal(f(2, 3), 5)\n})',
    fixed = TRUE
  )
})

test_that("Multiple functions", {
  out <- roxygen2::roc_proc_text(
    longtests_roclet(),
    "
      #' A function to do x
      #'
      #' @param x A number
      #'
      #' @longtests
      #' expect_equal(foo(2), sqrt(2))
      #' expect_error(foo(\"a string\"))
      #'
      #' @return something
      foo <- function(x) {
        return(sqrt(x))
      }

      #' A function to do y
      #'
      #' @param x Character vector
      #' @param y Character vector
      #'
      #' @longtests
      #' expect_equal(bar(\"A\", \"B\"), paste(\"A\", \"B\", sep = \"/\"))
      #'
      #' @export
      bar <- function(x, y) {
        paste0(x, \"/\", y)
      }

      #' A function with missing parameter docs
      #'
      #' @param x Character vector
      #'
      #' @export
      foobar <- function(x, y) {
        paste0(x, \"/\", y)
      }
    "
  )
  expect_equal(length(out), 1)
  expect_equal(length(out$longtests), 1)
  out <- out$longtests[[1]]

  # # Generated by biocroxytest: do not edit by hand!
  #
  # # <text>
  #
  # test_that("Function foo() @ L11", {
  #   expect_equal(foo(2), sqrt(2))
  #   expect_error(foo("a string"))
  # })
  #
  #
  # test_that("Function bar() @ L24", {
  #   expect_equal(bar("A", "B"), paste("A", "B", sep = "/"))
  # })

  expect_match(out, "^# Generated by biocroxytest: do not edit by hand!")
  expect_match(out, 'Function foo() @', fixed = TRUE)
  expect_match(out, 'Function bar() @', fixed = TRUE)
  expect_false(grepl('Function foobar() @', out, fixed = TRUE))
})

test_that("Remove content in \\donttest{} and \\dontrun{}", {
  out <- roxygen2::roc_proc_text(longtests_roclet(), "
    #' Summing two numbers
    #'
    #' @examples
    #' x <- 2
    #' \\donttest{
    #' a <- 3
    #' }
    #' \\dontrun{
    #' b <- runinf(1e6)
    #' hist(b)
    #' }
    #'
    #' @longtests
    #' expect_equal(x, 2)
    f <- function(x, y) {
      x + y
    }")
  expect_equal(length(out), 1)
  expect_equal(length(out$longtests), 1)

  out <- out$longtests[[1]]

  # # Generated by biocroxytest: do not edit by hand!
  #
  # # <text>
  #
  # test_that("Function f() @ L16", {
  #   expect_equal(x, 2)
  # })

  expect_match(out, "^# Generated by biocroxytest: do not edit by hand!")
  expect_match(out, '# <text>', fixed = TRUE)
  expect_match(out, 'expect_equal(x, 2)', fixed = TRUE)

  expect_false(grepl('donttest', out, fixed = TRUE))
  expect_false(grepl('dontrun', out, fixed = TRUE))

  expect_false(grepl('a <-', out, fixed = TRUE))
  expect_false(grepl('b <-', out, fixed = TRUE))
  expect_false(grepl('hist(b)', out, fixed = TRUE))
})

test_that("@rdname checks", {
  # length(block_rdname) >= 2L check
  roxygen2::roc_proc_text(longtests_roclet(), "
    #' @rdname foo
    #' @rdname bar
    #'
    NULL") |> expect_error()

  out <- roxygen2::roc_proc_text(longtests_roclet(), "
    #' @rdname foo
    #'
    NULL")
  expect_equal(length(out), 1)
  expect_equal(length(out$longtests), 0)
})

