% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_dbs.R
\name{build-dbs}
\alias{build-dbs}
\alias{build_db_from_source}
\alias{build_meta_aliases_db}
\alias{build_meta_rdxrefs_db}
\title{Helper functions to generate HTML pages for reference manuals}
\usage{
build_db_from_source(package_dir, reposRoot)

build_meta_aliases_db(web_dir, aliases_db_file, force = FALSE)

build_meta_rdxrefs_db(web_dir, rdxrefs_db_file, force = FALSE)
}
\arguments{
\item{package_dir}{`character(1)` The local path to a package for which to
build the aliases and cross-ref databases (`rds` files).}

\item{reposRoot}{`character(1)` The path to the base hosting directory for
the package repository. This is typically a location on the BBS server.}

\item{web_dir}{`character(1)` The `web/packages` local directory that is
also hosted on the website e.g., for CRAN
\url{https://cran.r-project.org/web/packages/}}

\item{aliases_db_file}{`character(1)` The file path to `aliases.rds` file
generated by the `build_db_from_source` function.}

\item{force}{`logical(1)` If `FALSE`, the function will only update the
database entries for which the aliases/rdxrefs file is more recent than the
database file. If `TRUE`, the function will read all aliases/rdxrefs files.}

\item{rdxrefs_db_file}{`character(1)` The file path to `rdxrefs.rds` file
generated by the `build_db_from_source` function.}
}
\description{
Helper functions to generate HTML pages for reference manuals
}
\details{
These functions are used to generate the `aliases.rds` and `rdxrefs.rds`
files for each package. These files are used to generate a metadata database
`Rds` file via the `build_meta_aliases_db` and `build_meta_rdxrefs_db`
functions for all packages. The `aliases.rds` file is a list of aliases
within each `.Rd` page in the package. The `rdxrefs.rds` file is a matrix of
cross-references between an external topic and the originating `.Rd` page.
The individual package databases are then combined into a single database
file for the entire repository. Each package's database is stored in the
`web/packages` directory in `reposRoot`. The collective metadata database
files are stored in the `src/contrib/Meta` directory in `reposRoot`.

The alias and cross-reference files are generated from the package source
directory but may also be generated from a built package tarball
(functionality not included). The code is meant to run on the BBS, typically
after a package has been built or updated.
}
\examples{
if (interactive()) {
    library(BiocPkgTools)
    bioc_sub <- pkgBiocDeps(
        "SummarizedExperiment", pkgType = "software",
        recursive = TRUE, only.bioc = TRUE
    )
    bioc_sub <- unlist(bioc_sub, use.names = FALSE)

    ## generate from Bioc package source dirs
    packages <- file.path(normalizePath("~/bioc"), bioc_sub)
    reposRoot <- "~/minibioc/packages/3.20/bioc"

    for (package in packages) {
       build_db_from_source(package, reposRoot)
    }
}
if (interactive()) {
    reposRoot <- "~/minibioc/packages/3.20/bioc/"
    web_dir <- file.path(reposRoot, "web", "packages")

    meta_folder <- file.path(contrib.url(reposRoot), "Meta")
    if (!dir.exists(meta_folder)) dir.create(meta_folder, recursive = TRUE)
    aliases_db_file <- file.path(meta_folder, "aliases.rds")

    meta_aliases_db <- build_meta_aliases_db(web_dir, aliases_db_file)

    saveRDS(meta_aliases_db, aliases_db_file, version = 2)
}
if (interactive()) {
    reposRoot <- "~/minibioc/packages/3.20/bioc/"
    web_dir <- file.path(reposRoot, "web", "packages")

    meta_folder <- file.path(contrib.url(reposRoot), "Meta")
    if (!dir.exists(meta_folder)) dir.create(meta_folder, recursive = TRUE)
    rdxrefs_db_file <- file.path(meta_folder, "rdxrefs.rds")

    meta_rdxrefs_db <- build_meta_rdxrefs_db(web_dir, rdxrefs_db_file)

    saveRDS(meta_rdxrefs_db, rdxrefs_db_file, version = 2)
}
}
