% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{bbSearch}
\alias{bbSearch}
\title{Search identifiers or special keywords}
\usage{
bbSearch(terms, source = NULL, filter = NULL, page = NULL,
  limit = 1000, showURL = FALSE, lite = TRUE)
}
\arguments{
\item{terms}{Comma seperated identifers or keywords}

\item{source}{Optional dataset identifiers to search only within this dataset.}

\item{filter}{Filter expression useful to filter out results when a keyword point several results. For instance if the biobtree index with multiple organism
a same gene search could hit several results for different species to filter only a specific species a filter can apply to search function.}

\item{page}{By default no need to pass this parameter since it returns all the results. It can be used with limit parameter for very large results to process them in paginated manner.
About paging every long search or mapping result paginated in biobtree and for paginated results every response contains a key to get the next page results. So if this
parameter is set with this key specified next page results returned for the given search term.}

\item{limit}{Limits the number of search results. By default without any limit all the results returned.}

\item{showURL}{allows returning the dataset source url}

\item{lite}{By default it is TRUE and allow function return quickly with data.frame containing most important fields. If set to TRUE function return raw results converted from json.}
}
\value{
returns search results in data.frame by default if lite set it true returns json object
}
\description{
Search identifiers or special keywords terms uniformly and resolve their actual unique identifiers and datasets. Keywords
can be several things for instance for uniprot an accession like "vav_human" can be a keyword which points to its original
identifier "P15498". Or gene name can be also a keyword like "tpi1" which could points multiple dataset like ensembl and hgnc.
}
\examples{

bbSearch("hunk,vav_human")

bbSearch("hunk","ensembl",filter='ensembl.genome=="homo_sapiens"')


}
\author{
Tamer Gur
}
