% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgeR_tidiers.R
\name{edgeR_tidiers}
\alias{edgeR_tidiers}
\alias{tidy.DGEExact}
\alias{tidy.DGEList}
\alias{augment.DGEList}
\alias{glance.DGEExact}
\title{Tidiers for edgeR's differential expression objects}
\usage{
\method{tidy}{DGEExact}(x, ...)

\method{tidy}{DGEList}(x, addSamples = FALSE, ...)

\method{augment}{DGEList}(x, data = NULL, ...)

\method{glance}{DGEExact}(x, alpha = 0.05, p.adjust.method = "fdr",
  ...)
}
\arguments{
\item{x}{DGEExact, DGEList object}

\item{...}{extra arguments (not used)}

\item{addSamples}{Merge information from samples. Default is FALSE.}

\item{data}{merge data to augment. This is particularly useful when merging
gene names or other per-gene information. Default is NULL.}

\item{alpha}{Confidence level to test for significance}

\item{p.adjust.method}{Method for adjusting p-values to determine
significance; can be any in p.adjust.methods}
}
\value{
\code{tidy} defaults to tidying the counts in
the dataset:
  \item{gene}{gene ID}
  \item{sample}{sample ID}
  \item{count}{number of reads in this gene in this sample}

If \code{addSamples = TRUE}, it also merges this with the sample information present
in \code{x$samples}.

\code{augment} returns per-gene information (DGEList only)

\code{glance} returns one row with the columns (DGEExact only)
  \item{significant}{number of significant genes using desired adjustment
  method and confidence level}
  \item{comparison}{The pair of groups compared by edgeR, delimited by /}
}
\description{
Tidy, augment and glance methods for turning edgeR objects into tidy data
frames, where each row represents one observation and each column represents
one column.
}
\examples{
if (require("edgeR")) {
    library(Biobase)
    data(hammer)
    hammer.counts <- exprs(hammer)[, 1:4]
    hammer.treatment <- phenoData(hammer)$protocol[1:4]

    y <- DGEList(counts=hammer.counts,group=hammer.treatment)
    y <- calcNormFactors(y)
    y <- estimateCommonDisp(y)
    y <- estimateTagwiseDisp(y)
    et <- exactTest(y)

    head(tidy(et))
    head(glance(et))
}

}
