% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialise_parameters.R
\name{initialise_parameters}
\alias{initialise_parameters}
\title{Initialising the betaHMM model parameters}
\usage{
initialise_parameters(data, M, N, R, seed = NULL)
}
\arguments{
\item{data}{A dataframe of dimension \eqn{C \times (N \times R)} containing
methylation values for \eqn{C} CpG sites from \eqn{R}
treatment groups each having \eqn{N} replicates or each
collected from \eqn{N} patients.}

\item{M}{Number of methylation states to be identified in a DNA sample.}

\item{N}{Number of patients or DNA sample replicates collected for each
treatment group.}

\item{R}{Number of treatment groups (For. eg: Benign and Tumour).}

\item{seed}{Seed to allow for reproducibility (default = NULL).}
}
\value{
A list containing:
\itemize{
\item A - The transition matrix for the betaHMM model.
\item tau - The initial distribution for the betaHMM model.
\item phi - The shape parameters for the observation sequence data
in the betaHMM model.}
}
\description{
Initialise the betaHMM model parameters.
}
\details{
Computes the shape parameters using the threshold_function to
initialise the shape parameters of the model.
}
\keyword{internal}
