% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedbaser.R
\name{bb_to_granges}
\alias{bb_to_granges}
\title{Create a GRanges object given a BED id}
\usage{
bb_to_granges(bedbase, bed_id, extra_cols = NULL, quietly = TRUE)
}
\arguments{
\item{bedbase}{BEDbase() object}

\item{bed_id}{integer(1) BED record identifier}

\item{extra_cols}{character() (default \code{NULL}) extra column names to
construct GRanges objects}

\item{quietly}{logical(1) (default \code{TRUE}) display messages}
}
\value{
\link[GenomicRanges:GRanges-class]{GRanges}
}
\description{
Create a GRanges object given a BED id. Columns and types
are generated for broad and narrow peak files. Known columns and types can
be passed as a named vector through \code{extra_cols}. Otherwise,
\code{bb_to_granges()} attempts to determine the column type and substitute dummy
column names.
}
\examples{
bedbase <- BEDbase()
ex_bed <- bb_example(bedbase, "bed")
bb_to_granges(bedbase, ex_bed$id)

}
