% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noisygene_detection.r
\name{NOISY_FUN}
\alias{NOISY_FUN}
\title{Noisy gene detection}
\usage{
NOISY_FUN(bay_array_N, bay_array_C, plot.out = FALSE)
}
\arguments{
\item{bay_array_N}{A 2D matrix or 3D array of normalized
data(real cells).}

\item{bay_array_C}{A 2D matrix or 3D array of normalized
data(synthetic control).}

\item{plot.out}{If TRUE, show CV^2 vs Mean
expression plot. Default is FALSE.}
}
\value{
A vector of adjusted P-values.
}
\description{
This function detects noisy genes using trends observed
in a set of synthetic controls. Input bayNorm normalized data
of real data (\code{bay_array_N}) and synthetic control
(\code{bay_array_C}) respectively.
}
\details{
\code{bay_array_N} and \code{bay_array_C}
should be of the same dimension.
}
\examples{
bay_array_N<-array(rpois(1000*50*2,17),dim=c(1000,50,2))
bay_array_C<-array(rpois(1000*50*2,58),dim=c(1000,50,2))
noisy_output<-NOISY_FUN(bay_array_N,bay_array_C)

}
