% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-plots.R
\name{mcmc_plot_probs}
\alias{mcmc_plot_probs}
\title{Generate a violin plot showing the probabilitiy of protein
localisation to different organelles}
\usage{
mcmc_plot_probs(
  params,
  fname,
  cond = 1,
  n = 1,
  bw = 0.05,
  scale = "width",
  trim = TRUE
)
}
\arguments{
\item{params}{An instance of class \code{bandleParams}}

\item{fname}{The name of the protein to plot}

\item{cond}{Which conditions do we want to plot. Must be \code{1} or \code{2}. Default
is \code{1}}

\item{n}{The chain from which we plot the probability distribution. Default
is 1.}

\item{bw}{The bandwidth use in probability distribution smoothing of
geom_violin Default is 0.05.}

\item{scale}{Scaling of geom_violin. Defaults to width.}

\item{trim}{trim parameter of geom_violin. Defaults to true.}
}
\value{
returns a named vector of differential localisation probabilities
}
\description{
These functions implement plotting functions for bandle objects
}
\examples{
library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                    numRep = 6L,
                   numDyn = 100L)
gpParams <- lapply(tansim$lopitrep, function(x) 
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))
d1 <- tansim$lopitrep
control1 <- d1[1:3]
treatment1 <- d1[4:6]
mcmc1 <- bandle(objectCond1 = control1,
 objectCond2 = treatment1, gpParams = gpParams,
 fcol = "markers", numIter = 5L, burnin = 1L, thin = 2L,
 numChains = 1, BPPARAM = SerialParam(RNGseed = 1))
mcmc_plot_probs(params = mcmc1, fname = rownames(tan2009r1)[1])

}
