# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title GP gradient with respect to the variance
#' @param Y data
#' @param drv deterivate of matern covariance wrt to sigma
#' @param nk number of observations
#' @param sigmak variance term
#' @param Z special matrix from trench algorithm (see Crook et al arxiv 2019)
#' @param D dimension of gaussian
#' @param Y2 vectorised data (see Crook et al arxiv 2019)
#' 
#' @md
#' 
#' @rdname bandle-cpp  
NULL

#' @title Helper method to subset data
#' @param X pointer to data to be subset
#' @param B pointer to subsetting matrix
#' @param j values of B on which to subset.
#' @md
#' 
#' @rdname bandle-cpp  
NULL

#' @param helper function to vectorise a matrix
#' @param &X pointer to data to be vectorised
NULL

#' @title bessel function of the second kind from boost library
#' @param x bessel arguement
#' @param v bessel parameter
#' 
#' @md
#' 
#' @rdname bandle-cpp   
besselK_boost <- function(x, v) {
    .Call(`_bandle_besselK_boost`, x, v)
}

#' @title vectorised bessel function of the 2nd kind
#' @param x bessel arguement
#' @param v bessel parameter
#' 
#' @md
#' 
#' @rdname bandle-cpp   
besselK <- function(x, v) {
    .Call(`_bandle_besselK`, x, v)
}

#' @title Compute a matern covariance
#' @param nu smoothness parameter
#' @param a amplitude
#' @param rho length-scale
#' @param tau indexing set
#' @param D dimension of covariance matrix
#' @md
#' 
#' @rdname bandle-cpp  
matern <- function(nu, a, rho, tau, D) {
    .Call(`_bandle_matern`, nu, a, rho, tau, D)
}

#' @title Compute matrix determinant using trench algorithm
#' @param c first row of toeplitz matrix
#' @md
#' 
#' @rdname bandle-cpp  
trenchDetcpp <- function(c) {
    .Call(`_bandle_trenchDetcpp`, c)
}

#' @title Compute matrix inverse using trench algorithm
#' @param v argument of trench algorithm
#' @md
#' 
#' @rdname bandle-cpp  
trenchInvcpp <- function(v) {
    .Call(`_bandle_trenchInvcpp`, v)
}

#' @title GP log liklihood using trench algorithms
#' @param Y data
#' @param Z special matrix from trench alogrithm (see Crook et al arxiv 2019)
#' @param A special matrix from trench alogrithm (see Crook et al arxiv 2019)
#' @param logcovDet log determine of the covariancematrix
#' @param sigmak variance term
#' @param nk number of observations
#' @param D dimension of gaussian
#' @param Y2 vectorised data (see Crook et al arxiv 2019)
#' 
#' @md
#' 
#' @rdname bandle-cpp  
loglikeGPcpp <- function(Y, Z, A, logcovDet, sigmak, nk, D, Y2) {
    .Call(`_bandle_loglikeGPcpp`, Y, Z, A, logcovDet, sigmak, nk, D, Y2)
}

#' @title negative log likliehood of data modelled using matern GP
#' @param Xk pointer to data
#' @param tau indexing set
#' @param h vector of hyperparameters
#' @param nk number of data points
#' @param D dimension of data
#' @param materncov logical indicating whether to use matern or gaussian 
#' covariance. Defaults to Guassian covariance
#' @param nu smoothness parameter of the matern covariance. Defaults to 2.
#' @md
#' 
#' @rdname bandle-cpp  
likelihoodGPcpp <- function(Xk, tau, h, nk, D, materncov = 0L, nu = 2) {
    .Call(`_bandle_likelihoodGPcpp`, Xk, tau, h, nk, D, materncov, nu)
}

#' @title GP gradient with respect to the length-scale
#' @param Y data
#' @param drvrhomatern deterivate of matern covariance wrt to rho
#' @param nk number of observations
#' @param D dimension of gaussian
#' @param Z special matrix from trench algorithm (see Crook et al arxiv 2019)
#' @param A special matrix from trench algorithm (see Crook et al arxiv 2019)
#' @param sigmak variance term
#' @md
#' 
#' @rdname bandle-cpp  
gradientrhomatern <- function(Y, drvrhomatern, nk, D, Z, A, sigmak) {
    .Call(`_bandle_gradientrhomatern`, Y, drvrhomatern, nk, D, Z, A, sigmak)
}

#' @title GP gradient with respect to the amplitude
#' @param Y data
#' @param amatern deterivate of matern covariance wrt to amplitude
#' @param nk number of observations
#' @param D dimension of gaussian
#' @param Z special matrix from trench algorithm (see Crook et al arxiv 2019)
#' @param A special matrix from trench algorithm (see Crook et al arxiv 2019)
#' @param sigmak variance term
#' @md
#' 
#' @rdname bandle-cpp  
gradientamatern <- function(Y, amatern, nk, D, Z, A, sigmak) {
    .Call(`_bandle_gradientamatern`, Y, amatern, nk, D, Z, A, sigmak)
}

#' @title GP full gradient
#' @param Xk pointer to data
#' @param tau indexing set
#' @param h vector of hyperparameters
#' @param nk number of data points
#' @param D dimension of data
#' @param nu smoothness parameter of the matern covariance. Defaults to 2.
#' 
#' @md
#' 
#' @rdname bandle-cpp  
gradientGPcppmatern <- function(Xk, tau, h, nk, D, nu) {
    .Call(`_bandle_gradientGPcppmatern`, Xk, tau, h, nk, D, nu)
}

#' @title leapfrog method
#' @description Leapfrog routine
#' @param Xk The data
#' @param lambda parameters of penalised complexity prior
#' @param tau indexing term
#' @param p momentum
#' @param x position
#' @param m mass
#' @param nk number of observations
#' @param D number of samples
#' @param L iterations
#' @param delta stepsize
#' @param nu smoothness of matern covariance
#' @md
#' 
#' @rdname bandle-cpp  
LeapfrogGPcppPC <- function(Xk, lambda, tau, p, x, m, nk, D, L, delta, nu) {
    .Call(`_bandle_LeapfrogGPcppPC`, Xk, lambda, tau, p, x, m, nk, D, L, delta, nu)
}

#' @title sample mean function of a matern GP
#' @param Xk data
#' @param tau indexing set
#' @param h vector of hyperparameters
#' @param nk number of data points
#' @param D dimension of data
#' @param nu smoothness parameter of the matern covariance.
#' @md
#' 
#' @rdname bandle-cpp  
sampleGPmeanmaterncpp <- function(Xk, tau, h, nk, D, nu) {
    .Call(`_bandle_sampleGPmeanmaterncpp`, Xk, tau, h, nk, D, nu)
}

#' @title helper function to construct a component matrix 
#' @param X pointer to data to be subset
#' @param BX pointer to subsetting matrix
#' @param Y pointer to data to be subset. X and Y will be joined
#' @param BY pointer to subsetting matrix
#' @param j values of B on which to subset.
#' @md
#' 
#' @rdname bandle-cpp  
makeComponent <- function(X, BX, Y, BY, j) {
    .Call(`_bandle_makeComponent`, X, BX, Y, BY, j)
}

#' @title sample mean GP function 
#' @param Xk data
#' @param tau indexing set
#' @param h vector of hyperparameters
#' @param nk number of data points
#' @param D dimension of data
#' @md
#' 
#' @rdname bandle-cpp  
sampleGPmeancpp <- function(Xk, tau, h, nk, D) {
    .Call(`_bandle_sampleGPmeancpp`, Xk, tau, h, nk, D)
}

#' @title normalise data by substracting GP mean
#' @param Xknown pointer to data with known localisations
#' @param BX pointer to indexing set to make component
#' @param Xunknown pointer to data with unknown localisations
#' @param BXun pointer to indexing set for unknown localisations
#' @param hypers pointer to vector of hyperparameters
#' @param nk pointer to number of observations in component
#' @param tau pointer to indexing set
#' @param D dimension of data
#' @param j indicator of localisations i.e. niche j
#' @md
#' 
#' @rdname bandle-cpp  
normalisedData <- function(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, j) {
    .Call(`_bandle_normalisedData`, Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, j)
}

#' @title normalise data by substracting GP mean using matern covariance
#' @param Xknown pointer to data with known localisations
#' @param BX pointer to indexing set to make component
#' @param Xunknown pointer to data with unknown localisations
#' @param BXun pointer to indexing set for unknown localisations
#' @param hypers pointer to vector of hyperparameters
#' @param nk pointer to number of observations in component
#' @param tau pointer to indexing set
#' @param D dimension of data
#' @param j indicator of localisations i.e. niche j
#' @param nu smoothness of matern covariance.
#' @md
#' 
#' @rdname bandle-cpp  
normalisedDatamatern <- function(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, j, nu) {
    .Call(`_bandle_normalisedDatamatern`, Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, j, nu)
}

#' @title Center data based on the Matern covariance
#' @param Xknown data with known localisations
#' @param BX indexing set to make component
#' @param Xunknown data with unknown localisations
#' @param BXun indexing set for unknown localisations
#' @param hypers vector of hyperparameters
#' @param nk number of observations in component
#' @param tau  indexing set
#' @param D dimension of data
#' @param K number of niches
#' @param nu smoothness parameter of matern covariance
#' @md
#' 
#' @rdname bandle-cpp  
centeredDatamatern <- function(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, K, nu) {
    .Call(`_bandle_centeredDatamatern`, Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, K, nu)
}

#' @title Compute negative log-likelihood of a component modelled as GP
#' @param centereddata pointer to centered data
#' @param sigmak variance term
#' @md
#' 
#' @rdname bandle-cpp  
componentloglike <- function(centereddata, sigmak) {
    .Call(`_bandle_componentloglike`, centereddata, sigmak)
}

#' @title Compute negative log-likleihood of all components
#' @param centereddata pointer to centered data
#' @param sigmak variance term
#' @md
#' 
#' @rdname bandle-cpp  
comploglike <- function(centereddata, sigmak) {
    .Call(`_bandle_comploglike`, centereddata, sigmak)
}

#' @title Compute log likelihoods from List of centered data
#' @param centereddata pointer to centered data
#' @param sigmak variance term
#' @md
#' 
#' @rdname bandle-cpp  
comploglikelist <- function(centereddata, sigmak) {
    .Call(`_bandle_comploglikelist`, centereddata, sigmak)
}

#' @title Sample from a Dirichlet distribution
#' @param numSamples The number of samples desired
#' @param alpha The concentration parameter
#' @md
#' 
#' @rdname bandle-cpp  
sampleDirichlet <- function(numSamples, alpha) {
    .Call(`_bandle_sampleDirichlet`, numSamples, alpha)
}

#' @title sample outlier allocations
#' @param allocoutlierprob The probabilities of being allocated to the outlier
#' component
#' @md
#' 
#' @rdname bandle-cpp  
sampleOutliercpp <- function(allocoutlierprob) {
    .Call(`_bandle_sampleOutliercpp`, allocoutlierprob)
}

#' @title sample allocation for components
#' @param allocprob probability of being allocated to particular component
#' @md
#' 
#' @rdname bandle-cpp  
sampleAlloccpp <- function(allocprob) {
    .Call(`_bandle_sampleAlloccpp`, allocprob)
}

#' @title center data based on mean of GP
#' @param Xknown data with known localisations
#' @param BX indexing set to make component
#' @param Xunknown data with unknown localisations
#' @param BXun indexing set for unknown localisations
#' @param hypers vector of hyperparameters
#' @param nk number of observations in component
#' @param tau  indexing set
#' @param D dimension of data
#' @param K number of components
#' @md
#' 
#' @rdname bandle-cpp  
centeredData <- function(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, K) {
    .Call(`_bandle_centeredData`, Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, K)
}

#'  Copyright (C) 2014 Matteo Fasiolo  matteo.fasiolo@gmail.com
#'This program is free software; you can redistribute it and/or
#' modify it under the terms of the GNU General Public License
#' as published by the Free Software Foundation; either version 2
#' of the License, or (at your option) any later version.
#' This program is distributed in the hope that it will be useful,
#' but WITHOUT ANY WARRANTY; without even the implied warranty of
#' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#' GNU General Public License for more details.
#' (www.gnu.org/copyleft/gpl.html)
#' You should have received a copy of the GNU General Public License
#' along with this program; if not, write to the Free Software
#' Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
#' USA. */
NULL

#' @title Fast mahalonbis distance
#' @param X data
#' @param mu mean
#' @param sigma variance matrix
#' @param isChol boolen indicated whether sigma is cholesky decomposition
#' @md
#' 
#' @rdname bandle-cpp  
mahaInt <- function(X, mu, sigma, isChol = FALSE) {
    .Call(`_bandle_mahaInt`, X, mu, sigma, isChol)
}

#' @title density of multivariate t
#' @param X data
#' @param mu mean
#' @param cholDec Cholesky decomposition of variance matrix
#' @param log boolen of log density
#' @param df degrees of freedom for t distribution
#' @md
#' 
#' @rdname bandle-cpp  
dmvtInt <- function(X, mu, cholDec, log, df) {
    .Call(`_bandle_dmvtInt`, X, mu, cholDec, log, df)
}

#' @title wrapper function for t distribution density
#' @param X_ the data
#' @param mu_ the mean
#' @param sigma_ the variance matrix
#' @param df_ the degrees of freedom
#' @param log_ return log density (boolean).
#' @param isChol_ is variance matrix in cholesky decomposition
#' @return A numeric indicating the density of the t-distribution
#' @md
#' 
#' @examples
#' dmvtCpp(diag(1,1,1), 1, diag(1,1,1), 1, TRUE, TRUE)
#' 
#' @rdname bandle-cpp  
dmvtCpp <- function(X_, mu_, sigma_, df_, log_, isChol_) {
    .Call(`_bandle_dmvtCpp`, X_, mu_, sigma_, df_, log_, isChol_)
}

#' @title Computes gradients of hyperaparamters with respect to GP
#' 
#' @param Y The data
#' @param drv matrix derivative
#' @param nk number of observations
#' @param D number of samples
#' @param Z internal matrix required for computations
#' @param A internal matrix required for computations
#' @param sigmak standard deviation parameter
#' @md
#' 
#' @rdname bandle-cpp
NULL

#' @title Computes gradients of  GP
#' @param Xk The data
#' @param tau indexing term
#' @param h vector of hyperparamters
#' @param nk number of observations
#' @param D number of samples
#' @md
#' 
#' @rdname bandle-cpp
gradientGPcpp <- function(Xk, tau, h, nk, D) {
    .Call(`_bandle_gradientGPcpp`, Xk, tau, h, nk, D)
}

#' @title leapfrog method
#' @description Leapfrog routine
#' @param Xk The data
#' @param tau indexing term
#' @param p momentum
#' @param x position
#' @param m mass
#' @param nk number of observations
#' @param D number of samples
#' @param L iterations
#' @param delta stepsize
#' @md
#' 
#' @rdname bandle-cpp
LeapfrogGPcpp <- function(Xk, tau, p, x, m, nk, D, L, delta) {
    .Call(`_bandle_LeapfrogGPcpp`, Xk, tau, p, x, m, nk, D, L, delta)
}

#' @title sample polya-gamma variates
#' @param b parameter of PG distribution
#' @param c parameter of PG distribution
#' @md
#' 
#' @rdname bandle-cpp
rcpp_pgdraw <- function(b, c) {
    .Call(`_bandle_rcpp_pgdraw`, b, c)
}

