% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{se}
\alias{se}
\alias{se,Bacon-method}
\title{Method to extract inflation- and bias-corrected standard errors}
\usage{
se(object, corrected = TRUE)

\S4method{se}{Bacon}(object, corrected = TRUE)
}
\arguments{
\item{object}{'bacon'-object}

\item{corrected}{optional return uncorrected}
}
\value{
vector or matrix of standard-errors
}
\description{
Method to extract inflation- and bias-corrected standard errors
}
\examples{
es <- replicate(6, rnormmix(2000, c(0.9, 0, 1, 0, 4, 1)))
se <- replicate(6, 0.8*sqrt(4/rchisq(2000,df=4)))
bc <- bacon(NULL, es, se)
head(se(bc))
}
\seealso{
\code{\link{bacon}}
}
