% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/34_enrichment.R
\name{group_by_level}
\alias{group_by_level}
\alias{group_by_level.character}
\alias{group_by_level.factor}
\alias{group_by_level.data.table}
\title{group by level}
\usage{
group_by_level(x, ...)

\method{group_by_level}{character}(x, ...)

\method{group_by_level}{factor}(x, ...)

\method{group_by_level}{data.table}(x, var, idvar, ...)
}
\arguments{
\item{x}{named logical/character/factor}

\item{...}{S3 dispatch}

\item{var}{string}

\item{idvar}{string}
}
\value{
unnamed character
}
\description{
group by level
}
\examples{
t1 <- c( KLF5 = 'up',  F11 = 'up', RIG = 'flat',   ABT1 = 'down')
dt <- data.table( gene = c( 'KL5', 'F11', 'RIG',  'ABT1' ), 
                    t1 = c( 'up',  'up',  'flat', 'down' ) )
group_by_level(t1)                #  character
group_by_level(factor(t1))        #     factor
group_by_level(dt, 't1', 'gene')  # data.table
}
