% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_plot.R
\name{mdsplot}
\alias{mdsplot}
\alias{fcor}
\alias{scor}
\alias{fdist}
\alias{sdist}
\title{Feature correlations/distances}
\usage{
mdsplot(distmat, title = NULL)

fcor(object, verbose = TRUE)

scor(object, verbose = TRUE)

fdist(object, method = "cor")

sdist(object, method = "cor")
}
\arguments{
\item{distmat}{distance matrix}

\item{title}{NULL or string}

\item{object}{SummarizedExperiment}

\item{verbose}{TRUE or FALSE}

\item{method}{'cor', 'euclidian', etc}
}
\value{
matrix
}
\description{
Feature correlations/distances
}
\examples{
# Correlations
    object <- twofactor_sumexp()
    scor(object)               \%>\%  pheatmap::pheatmap()
    fcor(object)               \%>\%  pheatmap::pheatmap()
# Distances
    sdist(object, 'cor')       \%>\% mdsplot('samples: cor')
    sdist(object, 'euclidian') \%>\% mdsplot('samples: euclidian')
    fdist(object, 'cor')       \%>\% mdsplot('features: cor')
    fdist(object, 'euclidian') \%>\% mdsplot('features: euclidian')
}
