% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/22_transform.R
\name{center}
\alias{center}
\alias{center_mean}
\alias{center_median}
\title{Center samples}
\usage{
center(
  object,
  selector = rep(TRUE, nrow(object)) == TRUE,
  fun = "median",
  verbose = TRUE
)

center_mean(object, ...)

center_median(object, ...)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{selector}{logical vector (length = nrow(object))}

\item{fun}{aggregation function (string)}

\item{verbose}{TRUE/FALSE}

\item{...}{parameters handed through to center()}
}
\value{
SummarizedExperiment
}
\description{
Center samples
}
\examples{
require(matrixStats)
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
fdt(object)$housekeeping <- FALSE
fdt(object)$housekeeping[order(rowVars(values(object)))[1:5]] <- TRUE
values(object)[, object$subgroup=='Adult'] \%<>\% magrittr::add(5)
plot_sample_densities(object)
plot_sample_densities(center(object))
plot_sample_densities(center(object, housekeeping))
}
