% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{OneCodeToFindThemAll}
\alias{OneCodeToFindThemAll}
\title{OneCodeToFindThemAll parser of RepeatMasker annotations}
\usage{
OneCodeToFindThemAll(
  gr,
  dictionary = NULL,
  fuzzy = FALSE,
  strict = FALSE,
  insert = -1,
  BPPARAM = SerialParam(progressbar = TRUE)
)
}
\arguments{
\item{gr}{A [`GRanges`][GenomicRanges::GRanges-class] object with
RepeatMasker annotations from \link[AnnotationHub]{AnnotationHub}}

\item{dictionary}{(Default NULL) When NULL, a dictionary is built based 
on names of repeats. If not, a data.frame with equivalences LTR - internal
regions created by the user, where first column should be the name of the
internal region and the second column should be the LTR(s). When more than
one LTR, these should be separated by ":".}

\item{fuzzy}{(Default FALSE) A logical; if TRUE, the search for equivalences
between internal parts and LTRs to reconstruct LTR class transposable 
elements is less stringent, allowing more matches between corresponding
subparts. This option can increase the proportion of false positives
(incorrectly reconstructed LTR class TEs).}

\item{strict}{(Default FALSE) A logical; if TRUE, the 80-80 rule is applied,
i.e. only copies with more than 80% identity to the reference
and more than 80 bp long are reported.}

\item{insert}{(Default -1) An integer. When \code{insert} < 0, two fragments
are assembled if the distance separating their furthest extremities is less 
than twice the reference length of the element. When \code{insert} > 0,
fragments are assembled if the distance between their closest extremities
is equal or less than \code{insert}. When \code{insert} = 0, two fragments
are assembled if they are in contact next to each other.}

\item{BPPARAM}{See \code{?\link[BiocParallel:bplapply]{bplapply}} in the 
BiocParallel package. Can be used to run calculations in parallel.}
}
\value{
A [`GRangesList`][GenomicRanges::GRangesList-class] object.
}
\description{
OneCodeToFindThemAll parser of RepeatMasker annotations
}
\details{
Implementation of One code to find them all 
\href{https://doi.org/10.1186/1759-8753-5-13}{(Bailly-Bechet et al. 2014)}.
Parses RepeatMasker annotations from UCSC by assembling together fragments
from the same transposable elemenet (TE) that are close enough (determined
by the \code{insert} parameter). For TEs from the LTR class, the parser
tries to reconstruct full-length, when possible, or partial TEs following
the LTR - internal region - LTR structure. Equivalences between internal
regions and flanking LTRs can be set by the user with the \code{dictionary}
parameter or can be obtained by the parser. In this last case, the 
\code{fuzzy} parameter determines the level of stringency when searching 
for LTR - internal region equivalences.
}
\examples{
\dontrun{
rmskoc <- annotaTEs(genome="dm6", parsefun=OneCodeToFindThemAll,
                    fuzzy=FALSE, strict=FALSE)
}

}
\references{
Bailly-Bechet et al. "One code to find them all": a perl tool to 
conveniently parse RepeatMasker output files. Mobile DNA. 2014;5(1):1-15.
DOI: \url{https://doi.org/10.1186/1759-8753-5-13}
}
