% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysisQuantifications.R
\name{artmsGeneratePhSiteExtended}
\alias{artmsGeneratePhSiteExtended}
\title{Generate ph-site specific detailed file}
\usage{
artmsGeneratePhSiteExtended(
  df,
  pathogen = "nopathogen",
  species,
  ptmType,
  output_name
)
}
\arguments{
\item{df}{(data.frame) of log2fc and imputed values}

\item{pathogen}{(char) Is there a pathogen in the dataset as well? Available
pathogens are \code{tb} (Tuberculosis), \code{lpn} (Legionella). If it is not,
then use \code{nopathogen} (default).}

\item{species}{(char) Main organism (supported for now: \code{human} or \code{mouse})}

\item{ptmType}{(char) It must be a ptm-site quantification dataset. Either:
yes: \code{ptmsites} (for site specific analysis), or
\code{ptmph} (Jeff's script output evidence file).}

\item{output_name}{(char) A output file name (extension \code{.txt} required)}
}
\value{
(data.frame) extended version of the ph-site
}
\description{
Generate extended detailed ph-site file, where every line is a
ph site instead of a peptide. Therefore, if one peptide has multiple ph sites
it will be breaking down in each of the sites. This file will help generate
input files for tools as \href{http://phosfate.com/}{Phosfate} or
\href{https://github.com/jdrudolph/photon}{PHOTON}
}
\examples{
\dontrun{
artmsGeneratePhSiteExtended(df = dfobject, 
                             species = "mouse", 
                             ptmType = "ptmsites",
                             output_name = log2fc_file)
}
}
\keyword{external,}
\keyword{phosfate}
\keyword{tools,}
