% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div_boxplot.R
\name{alpha_div_boxplot}
\alias{alpha_div_boxplot}
\title{Alpha diversity boxplot}
\usage{
alpha_div_boxplot(
  MAE,
  tax_level,
  condition,
  alpha_metric = c("inverse_simpson", "gini_simpson", "shannon", "fisher", "coverage",
    "unit")
)
}
\arguments{
\item{MAE}{A multi-assay experiment object. Required.}

\item{tax_level}{The taxon level used for organisms. Required.}

\item{condition}{Which condition to group samples. Required.}

\item{alpha_metric}{Which alpha diversity metric to use. Required. Can be one
of:"inverse_simpson", "gini_simpson", "shannon", "fisher", "coverage", "unit"}
}
\value{
A plotly object
}
\description{
Alpha diversity boxplot
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
p <- alpha_div_boxplot(toy_data,
  tax_level = "genus",
  condition = "DISEASE",
  alpha_metric = "shannon"
)
p

}
