% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplicanAlign.R
\name{amplicanAlign}
\alias{amplicanAlign}
\title{Align reads to amplicons.}
\usage{
amplicanAlign(
  config,
  fastq_folder,
  use_parallel = FALSE,
  average_quality = 30,
  min_quality = 20,
  filter_n = FALSE,
  batch_size = 1e+06,
  scoring_matrix = pwalign::nucleotideSubstitutionMatrix(match = 5, mismatch = -4,
    baseOnly = FALSE, type = "DNA"),
  gap_opening = 25,
  gap_extension = 0,
  fastqfiles = 0.5,
  primer_mismatch = 0,
  donor_mismatch = 3,
  donor_strict = FALSE
)
}
\arguments{
\item{config}{(string) The path to your configuration file. For example:
\code{system.file("extdata", "config.txt", package = "amplican")}.
Configuration file can contain additional columns, but first 11 columns
have to follow the example config specification.}

\item{fastq_folder}{(string) Path to FASTQ files. If not specified,
FASTQ files should be in the same directory as config file.}

\item{use_parallel}{(boolean) Set to TRUE, if you have registered
multicore back-end.}

\item{average_quality}{(numeric) The FASTQ file have a quality for each
nucleotide, depending on sequencing technology there exist many formats.
This package uses \code{\link[ShortRead]{readFastq}} to parse the reads.
If the average quality of the reads fall below value of
\code{average_quality} then sequence is filtered. Default is 0.}

\item{min_quality}{(numeric)  Similar as in average_quality, but depicts
the minimum quality for ALL nucleotides in given read. If one of nucleotides
has quality BELLOW \code{min_quality}, then the sequence is filtered.
Default is 20.}

\item{filter_n}{(boolean)  Whether to filter out reads containing N base.}

\item{batch_size}{(numeric) How many reads to analyze at a time? Needed for
filtering of large fastq files.}

\item{scoring_matrix}{(matrix) Default is 'NUC44'. Pass desired matrix using
\code{\link[pwalign]{nucleotideSubstitutionMatrix}}.}

\item{gap_opening}{(numeric) The opening gap score.}

\item{gap_extension}{(numeric) The gap extension score.}

\item{fastqfiles}{(numeric) Normally you want to use both FASTQ files. But in
some special cases, you may want to use only the forward file, or only
the reverse file. Possible options:
\describe{
 \item{0}{ Use both FASTQ files.}
 \item{0.5}{ Use both FASTQ files, but only for one of the reads (forward or
 reverse) is required to have primer perfectly matched to sequence - eg. use
 when reverse reads are trimmed of primers, but forward reads have forward
 primer in the sequence.}
 \item{1}{ Use only the forward FASTQ file.}
 \item{2}{ Use only the reverse FASTQ file.}
}}

\item{primer_mismatch}{(numeric) Decide how many mismatches are allowed
during primer matching of the reads, that groups reads by experiments.
When \code{primer_mismatch = 0} no mismatches are allowed, which can increase
number of unasssigned read.}

\item{donor_mismatch}{(numeric) How many events of length 1 (mismatches,
deletions and insertions of length 1) are allowed when aligning toward the
donor template. This parameter is only used when donor template is specified.
The higher the parameter the less strict will be algorithm accepting read as
HDR. Set to 0 if only perfect alignments to the donor template marked as HDR,
unadvised due to error rate of the sequencers.}

\item{donor_strict}{(logical) Applies more strict algorithm for HDR detection.
Only these reads that have all of the donor events will count as HDR. Tolerates `donor_mismatch`
level of noise, but no indels are allowed. Use this when your reads should span over the
whole window of the donor events. Might be more time consuming.}
}
\value{
(AlignmentsExperimentSet) Check \code{\link{AlignmentsExperimentSet}}
class for details. You can use \code{\link{lookupAlignment}} to examine
alignments visually.
}
\description{
amplicanAlign takes a configuration files, fastq reads and output
directory to prepare alignments and summary. It uses global Needleman-Wunsch
algorithm with parameters optimized for CRISPR experiment. After alignments,
object of \code{\link{AlignmentsExperimentSet}} is returned that allows for
coercion into GRanges (plus is for forward and minus for reverse reads).
It is also possible to output alignments in other, additional formats.
}
\examples{
# path to example config file
config <- system.file("extdata", "config.csv", package = "amplican")
# path to example fastq files
fastq_folder <- system.file("extdata", package = "amplican")
aln <- amplicanAlign(config, fastq_folder)
aln

}
\seealso{
Other analysis steps: 
\code{\link{amplicanConsensus}()},
\code{\link{amplicanFilter}()},
\code{\link{amplicanMap}()},
\code{\link{amplicanNormalize}()},
\code{\link{amplicanOverlap}()},
\code{\link{amplicanPipeline}()},
\code{\link{amplicanPipelineConservative}()},
\code{\link{amplicanReport}()},
\code{\link{amplicanSummarize}()}
}
\concept{analysis steps}
