% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMultiAssayExperiment.R
\name{readMultiAssayExperiment}
\alias{readMultiAssayExperiment}
\alias{loadMultiAssayExperiment}
\title{Read a MultiAssayExperiment from disk}
\usage{
readMultiAssayExperiment(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created using the \code{\link{stageObject}} method for \linkS4class{MultiAssayExperiment} objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments passed to internal \code{\link{altReadObject}} calls.}
}
\value{
A \linkS4class{MultiAssayExperiment} object.
}
\description{
Read a \linkS4class{MultiAssayExperiment} from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
library(SummarizedExperiment)

# Mocking up an MAE
mat <- matrix(rnorm(1000), ncol=10)
colnames(mat) <- letters[1:10]
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))
se <- SummarizedExperiment(list(counts=mat))

library(MultiAssayExperiment)
mae <- MultiAssayExperiment(list(gene=se))

# Staging it:
tmp <- tempfile()
dir.create(tmp)
info <- stageObject(mae, tmp, "dataset")

# Loading it back in:
loadMultiAssayExperiment(info, tmp)

}
\author{
Aaron Lun
}
