% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Preprocess the SingleCellExperiment}
\usage{
preprocess(sce, pc = 2)
}
\arguments{
\item{sce}{SingleCellExperiment with \code{a1} (effect allele)
and \code{a2} (non-effect allele). The allelic ratio will be
calculated as a1 / (a1 + a2).}

\item{pc}{pseudocount for calculating the smoothed ratio}
}
\value{
SingleCellExperiment with total count,
allelic ratio = a1/(a1 + a2), and pseud-ocount-smoothed ratio
}
\description{
Preprocess the SingleCellExperiment
}
\examples{
library(SummarizedExperiment)
sce <- makeSimulatedData()
sce <- preprocess(sce)
assayNames(sce)
}
