% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeForest.R
\name{makeForest}
\alias{makeForest}
\title{Plot allelic ratio result as forest}
\usage{
makeForest(
  sce,
  genepoi,
  ctpoi = seq_len(nlevels(sce$x)),
  showtext = FALSE,
  xticks,
  boxsize = 0.25,
  xlab = "Allelic Ratio",
  col,
  grid = structure(seq(0.1, 0.9, 0.1), gp = gpar(lty = 2, col = "#CCCCFF")),
  ...
)
}
\arguments{
\item{sce}{A SingleCellExperiment containing colData
allelic ratio estimator in the third column
and last two column is the confidence interval.}

\item{genepoi}{the gene position index or gene name vector that want to be plotted.
Ordered by increased cell type svalue.
Default is the top 40 genes that has minimum svalue in any cell type
or all genes if number of genes smaller than 40.}

\item{ctpoi}{the cell type position index that want to be plotted.}

\item{showtext}{indicate whether show the svalue information along the forestplot.}

\item{xticks}{argument as described in \code{\link[forestplot]{forestplot}}}

\item{boxsize}{Override the default box size based on precision}

\item{xlab}{x-axis label. Default is "Allelic Ratio"}

\item{col}{Set the colors for all the elements. See
\code{\link[forestplot]{fpColors}} for details}

\item{grid}{If you want a discrete gray dashed grid
at the level of the ticks
you can set this parameter to TRUE.
If you set the parameter to a vector of values lines will be drawn at the
corresponding positions.
If you want to specify the \code{\link[grid]{gpar}} of the lines
then either directly pass a \code{\link[grid]{gpar}} object
or set the gp attribute e.g.
\code{attr(line_vector, "gp") <- }
\code{\link[grid]{gpar}}\code{(lty=2, col = "red")}}

\item{...}{Passsed on the other argument in
\code{\link[forestplot]{forestplot}}.}
}
\value{
generates a forest plot
}
\description{
Draw a forest plot to visualized cell type specific
allelic ratio estimator and confidence interval.
It is based on the \pkg{forestplot}-package`s \code{forestplot} function.
}
\examples{
sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = 1:4)
sce_sub <- wilcoxExt(sce, genecluster = 1)
sce_sub <- allelicRatio(sce_sub)
makeForest(sce_sub, showtext = TRUE)

# if want to change some properties, like ticks position
library(forestplot)
xticks <- seq(from = 0, to = 1, by = 0.25)
xtlab <- rep(c(TRUE, FALSE), length.out = length(xticks))
attr(xticks, "labels") <- xtlab
genepoi <- paste0("gene", seq_len(5))
ctpoi <- c(1, 3)
makeForest(sce_sub, genepoi, ctpoi,
  xticks = xticks,
  col = fpColors(box = c("blue", "red", "black", "darkgreen"))
)
}
\seealso{
\code{\link[forestplot]{forestplot}},
\code{\link[forestplot]{fpColors}},
\code{\link[forestplot]{fpShapesGp}}, \code{\link[forestplot]{fpLegend}}
}
