% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{advList-class}
\alias{advList-class}
\alias{advList}
\title{adverSCarial class}
\value{
A advList object
}
\description{
\code{advList} is a class used to store the output values
of the \code{advSingleGene} function. The result can be a list
of few thousands genes:cell_type key/values, so a specific \emph{show}
method is associated to this class to avoid overflooding the R
scripts outputs.
}
\examples{
MyClassifier <- function(expr, clusters, target) {
   c("B cell", 0.9)
}
rna_expression <- data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
     CD8B=c(2,2,3,3))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","B cell","T cell","T cell")

adv_min_change <- advSingleGene(rna_expression, clusters_id,
"T cell", MyClassifier, advMethod="perc99")

adv_min_change

}
