% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{advChar-class}
\alias{advChar-class}
\alias{advChar}
\title{adverSCarial class}
\value{
A advChar object
}
\description{
\code{advChar} is a class used to store the output values
of the \code{advMaxChange} function. The result can be a vector
of few thousands genes, so a specific \emph{show} method is associated to
this class to avoid overflooding the R scripts outputs.
}
\examples{
MyClassifier <- function(expr, clusters, target) {
  c("T cell", 0.9)
}

genes <- paste0("gene_",1:10000)
rna_expression <- data.frame(lapply(genes, function(x) numeric(0)))
rna_expression <- rbind(rna_expression, rep(1,10000))
rna_expression <- rbind(rna_expression, rep(2,10000))
colnames(rna_expression) <- genes
clusters_id <- c("B cell","T cell")

max_change_genes <- advMaxChange(rna_expression, clusters_id,
"T cell", MyClassifier, advMethod="perc99")
                                   
max_change_genes
}
