% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upstreamAnalysis.R
\name{.UTR5Analysis}
\alias{.UTR5Analysis}
\title{5' UTR analysis}
\usage{
.UTR5Analysis(utr5Directories, utr5Out, sampleNames, combinedNames,
  mashedNames, upstreamRanges, .save = TRUE)
}
\arguments{
\item{utr5Directories}{list type. 5UTR directories where files are located}

\item{utr5Out}{string type. Where to dump output}

\item{sampleNames}{vector type. 1-1 with utr5Directories}

\item{combinedNames}{string type. Title friendly string}

\item{mashedNames}{string type. File name friendly string}

\item{upstreamRanges}{list type. Upstream ranges for each sample.
If length(utr5Directories) > 1, the plots will only be generated for
upstream ranges that are present in ALL samples. (i.e the intersection)}

\item{.save}{logical type, save Rdata?}
}
\value{
none
}
\description{
Generates all the required plots for 5' UTR analysis. This
includes upstream length distributions and upstream sequence validity.
}
