% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbSeqRep.R
\docType{class}
\name{AbSeqRep-class}
\alias{AbSeqRep-class}
\alias{AbSeqRep}
\title{S4 class - AbSeqRepertoire analysis object}
\value{
AbSeqRep
}
\description{
The AbSeqRep object contains all metadata associated with
the AbSeq (python backend) run conducted on it. This S4 class represents
a single sample(repertoire) and it can be "combined" with other samples
by using the \code{+} operator to create an \linkS4class{AbSeqCRep} object.
This value, in turn, can be used as the first argument to
\link{report} which generates a comparison between all samples included
in the \code{+} operation.

Users do not manually construct this class, but rather indirectly
obtain this class object as a return value
from the \link{abseqReport} and \link{report} functions.
}
\section{Slots}{

\describe{
\item{\code{f1}}{character. Path to FASTA/FASTQ file 1.}

\item{\code{f2}}{character. Path to FASTA/FASTQ file 2.}

\item{\code{chain}}{character. Type of chain, possible values:
\itemize{
  \item{hv}
  \item{lv}
  \item{kv}
  \item{klv}
}
each representing \bold{H}eavy, \bold{L}ambda and \bold{K}appa respectively.}

\item{\code{task}}{character. Type of analysis conducted, possible values:
\itemize{
  \item{all}
  \item{annotate}
  \item{abundance}
  \item{diversity}
  \item{productivity}
  \item{fastqc}
  \item{primer}
  \item{5utr}
  \item{rsasimple}
  \item{seqlen}
  \item{secretion}
  \item{seqlenclass}
}}

\item{\code{name}}{character. Name of analysis.}

\item{\code{bitscore}}{numeric. Part of filtering criteria: V gene bitscore filter value.}

\item{\code{qstart}}{numeric. Part of filtering criteria: V gene query start filter value.}

\item{\code{sstart}}{numeric. Part of filtering criteria: V gene subject start filter value.}

\item{\code{alignlen}}{numeric. Part of filtering criteria: V gene alignment length filter value.}

\item{\code{clonelimit}}{numeric. Number of clones to export into csv file. This is
only relevant in \code{-t all} or \code{-t diversity} where clonotypes
are exported into \code{<outdir>/<name>/diversity/clonotypes}}

\item{\code{detailedComposition}}{logical. Plots composition logo by IGHV families if
set to true, otherwise, plots logos by FR/CDRs.}

\item{\code{log}}{character. Path to log file.}

\item{\code{merger}}{character. Merger used to merge paired-end reads.}

\item{\code{fmt}}{character. File format of \code{file1} and (if present) \code{file2}.
Possible values are FASTA or FASTQ.}

\item{\code{sites}}{character. Path to restriction sites \code{txt} file.
This option is only used if \code{-t rsasimple}}

\item{\code{primer5end}}{ANY. Path to 5' end primer FASTA file.}

\item{\code{primer3end}}{ANY. Path to 3' end primer FASTA file.}

\item{\code{trim5}}{numeric. Number of nucleotides to trimd at the 5' end;}

\item{\code{trim3}}{numeric. Number of nucleotides to trimd at the 3' end;}

\item{\code{outdir}}{character. Path to output directory}

\item{\code{primer5endoffset}}{numeric. Number of nucleotides to offset before aligning
5' end primers in \code{primer5end} FASTA file.}

\item{\code{threads}}{numeric. Number of threads to run.}

\item{\code{upstream}}{character. Index (range) of upstream nucleotides to analyze.
This option is only used if \code{-t 5utr} or \code{-t secretion}.}

\item{\code{seqtype}}{character. Sequence type, possible values are either \code{dna}
or \code{protein}.}

\item{\code{database}}{character. Path to IgBLAST database.}

\item{\code{actualqstart}}{numeric. Query sequence's starting index (indexing starts from 1).
This value overrides the inferred query start position by AbSeq.}

\item{\code{fr4cut}}{logical. The end of FR4 is marked as the end of the sequence if
set to TRUE, otherwise the end of the sequence is either the end of the read
itself, or trimmed to \code{--trim3 <num>}.}

\item{\code{domainSystem}}{character. Domain system to use in IgBLAST, possible
values are either \code{imgt} or \code{kabat}.}
}}

\examples{
# this class is not directly constructed by users, but as a return
# value from the abseqReport method.

# Use example data from abseqR as abseqPy's output, substitute this
# with your own abseqPy output directory
abseqPyOutput <- tempdir()
file.copy(system.file("extdata", "ex", package = "abseqR"), abseqPyOutput, recursive=TRUE)
samples <- abseqReport(file.path(abseqPyOutput, "ex"), report = 0)
}
\seealso{
\code{\link{abseqReport}} returns a \code{list} of \code{AbSeqRep}
objects.
}
