% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported.R
\name{predict_per_variant}
\alias{predict_per_variant}
\title{predicts zygosity of a set of variants}
\usage{
predict_per_variant(
  purity,
  sex,
  somCna,
  geneModel = NULL,
  somSmallVars = NULL,
  germSmallVars = NULL,
  ploidy = NULL,
  colnameTcn = NULL,
  colnameCnaType = NULL,
  includeHomoDel = TRUE,
  includeIncompleteDel = TRUE,
  assumeSomCnaGaps = FALSE,
  byTcn = TRUE,
  ZP_env = NULL,
  verbose = FALSE
)
}
\arguments{
\item{purity}{purity of the sample (numeric value between 0 and 1 indicating 
the fraction of relevant sample with control/unrelevant tissue)}

\item{sex}{sex of the sample (character: "male", "female", "m", "f")}

\item{somCna}{GRanges object containing all genomic regions with annotated 
total copynumber and cna_type as metadata columns. The total-copynumber 
column should be named "tcn" but also some other commonly used names. 
It should contain numeric values or characters that can be converted to 
numeric values. The cna_type column must contain the information about 
loss of heterozygosity (LOH). Therefore the term "LOH" must be explicitely 
mentioned in the column. If a genomic region is not present in the object, 
it will be taken as heterozygous with neutral TCN of 2.}

\item{geneModel}{GRanges object containing the gene-annoattion of 
the used reference genome with metadata column of the gene name (gene)}

\item{somSmallVars}{GRanges object containing all somatic small 
variants (SNV and INDEL).
Required metadata columns are reference base (ref/REF), 
alternative base (alt/ALT),
annotation of the gene name (gene/GENE) and the allele-frequency (af/AF). 
If the object is not provided the tool assumes there are no somatic small 
variants.}

\item{germSmallVars}{GRanges object containing all germline small 
variants (SNV and INDEL).
Required metadata columns are reference base (ref/REF), alternative 
base (alt/ALT),
annotation of the gene name (gene/GENE) and the allele-frequency (af/AF)
If the object is not provided the tool assumes there are no germline small 
variants.}

\item{ploidy}{ploidy of the sample (numeric value)}

\item{colnameTcn}{character indicating the name of the metadata containing 
the tcn information in the somCna object. If not provided the tool tries to 
detect the column according to default names}

\item{colnameCnaType}{character indicating the name of the metadata 
containing cna type information in the somCna object. 
If not provided the tool tries to detect the column according to default 
names}

\item{includeHomoDel}{default = TRUE; if FALSE homozygous deleteions are 
excluded}

\item{includeIncompleteDel}{default = TRUE; if FALSE heterzygous deleteions 
are excluded}

\item{assumeSomCnaGaps}{(logical, default=FALSE) Only required if the somCna
object lacks copy number information for genomic segments on which small 
variants are detected. By default, variants in such regions will be excluded 
from the analysis as required information about the copy number is missing. 
These variants will be attached to the final output list in a separate 
tibble. To include them, this flag must be set TRUE and the ground ploidy 
must be given as an input. This ground ploidy will then be taken as tcn in 
the missing regions. If no ploidy is given the tool will assume the ground 
ploidy of 2 when this flag is TRUE.}

\item{byTcn}{logical, default=TRUE; optional if includeHomoDel or 
includeIncompleteDelS is TRUE. If FALSE the tool will not use tcn as a 
criterion to assign large deletions. It will use the cna_type column and 
check for indicating strings like HOMDEL/HomoDel/DEL. Some commonly used 
strings are covered. It is recommended to leave this flag TRUE}

\item{ZP_env}{internal variable... not recommened to be changed by user}

\item{verbose}{logical, default=FALSE; prints functions that are called}
}
\value{
A list containing tibbles with all input variants
}
\description{
predicts zygosity of a set of variants
}
\examples{
cnvs  = GenomicRanges::GRanges(
  dplyr::tibble(
    chr = "chr17",
    start = c(170060, 34520990),
    end = c(34520990, 83198614),
    tcn = c(2, 1),
    cna_type = c("neutral", "LOH")
  )
)
somatic_vars = GenomicRanges::GRanges(
  dplyr::tibble(
    chr="chr17",
    start = 7675088,
    end = 7675088,
    ref = "C",
    alt = "T",
    af = 0.65,
    gene = "TP53" 
  )
)
germline_vars = GenomicRanges::GRanges(
  dplyr::tibble(
    chr="chr17",
    start = 41771694,
    end = 41771694,
    ref = "GTGT",
    alt = "G",
    af = 0.95,
    gene = "JUP" 
  )
)
reference = GenomicRanges::GRanges(
  dplyr::tibble(
    chr = "chr17",
    start = c(7661778, 41754603),
    end = c(7687538, 41786931),
    gene = c("TP53", "JUP")
  )
)
sex = "female"
purity = 0.9
predict_per_variant(purity = purity, sex = sex, 
  somCna = cnvs,
  somSmallVars = somatic_vars,
  germSmallVars = germline_vars,
  geneModel = reference
)
}
