% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{compare_sets}
\alias{compare_sets}
\title{Compare two sets of signatures by cosine distance}
\usage{
compare_sets(in_df_small, in_df_big, in_distance = cosineDist)
}
\arguments{
\item{in_df_small, in_df_big}{Numerical data frames \code{W1} and 
\code{W2}, ideally the bigger one first, both with \code{n} rows
and \code{l1} and \code{l2} columns, \code{n} being the number of
features and \code{l1} and \code{l2} being the respective numbers
of signatures of \code{W1} and \code{W2}}

\item{in_distance}{A function which computes the distance measure, default
is \code{\link{cosineDist}}}
}
\value{
A list with entries
 \code{distance},
 \code{hierarchy_small} and
 \code{hierarchy_big}.
\itemize{
 \item \code{distance}:
   A numerical data frame with the cosine distances between the
   columns of \code{W1}, indexing the rows, and \code{W2}, indexing
   the columns
 \item \code{hierarchy_small}:
   A data frame carrying the information of ranked similarity between
   the signatures in \code{W2} with the signatures in \code{W1}
 \item \code{hierarchy_big}:
   A data frame carrying the information of ranked similarity between
   the signatures in \code{W1} with the signatures in \code{W2}
}
}
\description{
Compare two sets of signatures, stored in numerical data frames
\code{W1} and \code{W2}, by computing the column-wise cosine distance
}
\examples{
sig_1_df <- data.frame(matrix(c(1,0,0,0,0,1,0,0,0,0,1,0),ncol=3))
names(sig_1_df) <- paste0("B",seq_len(dim(sig_1_df)[2]))
sig_2_df <- data.frame(matrix(c(1,1,0,0,0,0,1,1),ncol=2))
compare_sets(sig_1_df,sig_2_df)

}
\seealso{
\code{\link{cosineDist}}
}
