% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadXevaSet.R
\name{downloadXevaSet}
\alias{downloadXevaSet}
\title{Download a XevaSet object or table of available XevaSet objects}
\usage{
downloadXevaSet(
  name = NULL,
  saveDir = file.path(".", "XevaSet"),
  XevaSetFileName = NULL,
  verbose = TRUE
)
}
\arguments{
\item{name}{Character string, the name of the XevaSet to download.}

\item{saveDir}{\code{Character} string with the folder path where the XevaSet should be saved. Defaults to './XevaSet/'. Will create directory if it does not exist.}

\item{XevaSetFileName}{\code{character} string, the file name to save the dataset under}

\item{verbose}{\code{bool} Should status messages be printed during download. Defaults to TRUE.}
}
\value{
A data.frame if name is NULL, showing all the available XevaSet objects. If name is specified, it will download the dataset from our server
}
\description{
This function allows you to see the available XevaSet object and
download them for use with this package. The XevaSet have been extensively
curated and organised within a XevaSet class, enabling use with all the
analysis tools provided in Xeva.
}
