% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XevaSet_Class.R
\name{createXevaSet}
\alias{createXevaSet}
\title{XevaSet constructor}
\usage{
createXevaSet(
  name,
  model = data.frame(),
  drug = data.frame(),
  experiment = data.frame(),
  expDesign = list(),
  modelSensitivity = data.frame(),
  batchSensitivity = data.frame(),
  molecularProfiles = list(),
  modToBiobaseMap = data.frame()
)
}
\arguments{
\item{name}{A \code{character} string detailing the name of the dataset.}

\item{model}{A \code{data.frame} containing the annotations for all the models used
in the experiment.}

\item{drug}{A \code{data.frame} containing the annotations for all the drugs
profiled in the dataset, across all data types.}

\item{experiment}{A \code{data.frame} containing all experiment information.}

\item{expDesign}{A list containing name of the batch, control and treatment model.id}

\item{modelSensitivity}{A \code{data.frame} containing sensitivity for each model}

\item{batchSensitivity}{A \code{data.frame} containing sensitivity for each batch}

\item{molecularProfiles}{A \code{list} of \code{ExpressionSet} objects containing
different molecular profiles.}

\item{modToBiobaseMap}{A \code{data.frame} containing model.id corresponding Biobase object id and name of the molecularProfiles}
}
\value{
Returns Xeva object
}
\description{
A constructor to create XevaSet. Only objects returned by this constructor
are expected to work with the XevaSet methods.
}
\details{
This function creates a XevaSet object. It takes different model
infromation and genomic data as input. For detailed discription of all
varaibles please see Xeva vignette section \strong{"Creating new Xeva object"}
}
\examples{
## read raw data files containg PDX experiment information and genomic data
model = read.csv(system.file("extdata", "model.csv", package = "Xeva"))
drug = read.csv(system.file("extdata", "drug.csv", package = "Xeva"))
experiment= read.csv(system.file("extdata", "experiments.csv", package = "Xeva"))
expDesign=readRDS(system.file("extdata", "batch_list.rds", package = "Xeva"))
RNASeq=readRDS(system.file("extdata", "rnaseq.rds", package = "Xeva"))
modToBiobaseMap=read.csv(system.file("extdata", "modelToExpressionMap.csv", package = "Xeva"))

## create Xeva object
xeva.set = createXevaSet(name="example xevaSet", model=model, drug=drug,
                         experiment=experiment, expDesign=expDesign,
                         molecularProfiles=list(RNASeq = RNASeq),
                         modToBiobaseMap = modToBiobaseMap)
print(xeva.set)

}
