% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{ABC}
\alias{ABC}
\title{area between curves
Computes the area between two time-volume curves.}
\usage{
ABC(
  contr.time = NULL,
  contr.volume = NULL,
  treat.time = NULL,
  treat.volume = NULL
)
}
\arguments{
\item{contr.time}{Time vector for control.}

\item{contr.volume}{Volume vector for control.}

\item{treat.time}{Time vector for treatment.}

\item{treat.volume}{Volume vector for treatment.}
}
\value{
Returns batch response object.
}
\description{
area between curves
Computes the area between two time-volume curves.
}
\examples{
contr.time <- treat.time  <- c(0, 3, 7, 11, 18, 22, 26, 30, 32, 35)
contr.volume<- contr.time * tan(60*pi/180)
treat.volume<- treat.time * tan(15*pi/180)
abc <- ABC(contr.time, contr.volume, treat.time, treat.volume)
par(pty="s")
xylimit <- range(c(contr.time, contr.volume, treat.time, treat.volume))
plot(contr.time, contr.volume, type = "b", xlim = xylimit, ylim = xylimit)
lines(treat.time, treat.volume, type = "b")
polygon(c(treat.time, rev(treat.time)), c(contr.volume, rev(treat.volume)),
        col = "#fa9fb5", border = NA)

}
