% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_analysis.R
\name{xina_enrichment}
\alias{xina_enrichment}
\title{xina_enrichment}
\usage{
xina_enrichment(string_db, protein_list, enrichment_type = "GO",
  pval_threshold = 0.05, methodMT = "fdr")
}
\arguments{
\item{string_db}{STRINGdb object}

\item{protein_list}{A vector of gene names to draw protein-protein interaction network.}

\item{enrichment_type}{A functional annotation for the enrichment test.
'enrichment_type' should be one of 'GO' and 'KEGG',}

\item{pval_threshold}{P-value threshold to get significantly enriched terms from the given proteins}

\item{methodMT}{Method for p-value adjustment. See \link[STRINGdb]{get_enrichment}. Default is 'fdr'.}
}
\value{
A list of data frames containing enrichment results
}
\description{
xina_enrichment conducts functional enrichment tests using gene ontology or KEGG pathway terms for a given protein list
}
\examples{
\dontrun{
library(STRINGdb)
library(Biobase)

# load XINA example data
data(xina_example)

# Get STRING database for protein-protein intereaction information
string_db <- STRINGdb$new( version="10", species=9606, score_threshold=0, input_directory="" )
string_db

# XINA analysis with STRING DB
xina_result <- xina_analysis(example_clusters, string_db)

# Select proteins that showed cluster #1 in the Stimulus2 condition
subgroup <- subset(example_clusters$aligned, Stimulus2==1)
protein_list <- as.vector(subgroup$`Gene name`)

# Enrichment test using KEGG pathway terms that have adjuseted p-value less than 0.1
kegg_enriched <- xina_enrichment(string_db, protein_list,
enrichment_type = "KEGG", pval_threshold=0.1)
plot_enrichment_results(kegg_enriched$KEGG, num_terms=10)

# Enrichment test using GO terms that have adjuseted p-value less than 0.1
go_enriched <- xina_enrichment(string_db, protein_list,
enrichment_type = "GO", pval_threshold=0.1)
plot_enrichment_results(go_enriched$Component, num_terms=10)
}

}
