% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_plots.R
\name{plot_enrichment_results}
\alias{plot_enrichment_results}
\title{plot_enrichment_results}
\usage{
plot_enrichment_results(enriched_results,
  term_description = "term_description", sig_score = "pvalue",
  num_terms = 0, get_log = TRUE, fill_color = "darkgray")
}
\arguments{
\item{enriched_results}{GO or KEGG enrichment results.
See \link[XINA]{xina_enrichment} and \link[XINA]{xina_enrichment}}

\item{term_description}{Description of terms to be drawn on Y axis.
Default is "term_description" of XINA enrichment results.}

\item{sig_score}{significant score to plot on X axis. Default is "pvalue".}

\item{num_terms}{The number of terms to be plotted.  Default is 0, which menas no limit.}

\item{get_log}{If this is TRUE, 'plot_enrichment_results' will take -log10 of p-values.}

\item{fill_color}{Default is 'darkgray'. You can change color of bars.}
}
\value{
ggplot bar graph
}
\description{
Plot GO and KEGG enrichment results
}
\examples{
\dontrun{
library(STRINGdb)

# load XINA example data
data(xina_example)

# Get STRING database for protein-protein intereaction information
string_db <- STRINGdb$new( version="10", species=9606,
score_threshold=0, input_directory="" )
string_db

# XINA analysis with STRING DB
xina_result <- xina_analysis(example_clusters, string_db)

# Select proteins that showed cluster #1 in the Stimulus2 condition
subgroup <- subset(example_clusters$aligned, Stimulus2==1)
protein_list <- as.vector(subgroup$`Gene name`)

# Enrichment test and get significantly enriched functional terms
# that have adjuseted p-value less than 0.1
kegg_enriched <- xina_enrichment(string_db, protein_list,
enrichment_type = "KEGG", pval_threshold=0.1)
plot_enrichment_results(kegg_enriched$KEGG, num_terms=10)
}

}
