% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregulstions.R
\name{draw_alluvial_plot}
\alias{draw_alluvial_plot}
\title{draw_alluvial_plot}
\usage{
draw_alluvial_plot(clustering_result, selected_conditions, count_table,
  alluvia_colors = NULL, cex = 0.7, alpha = 0.3)
}
\arguments{
\item{clustering_result}{A list containing XINA clustering results.
See \link[XINA]{xina_clustering}.}

\item{selected_conditions}{A vector of condition names used in XINA clustering results.
The number of selected conditions should be at least two.}

\item{count_table}{A data frame generated by using \link[plyr]{count}.}

\item{alluvia_colors}{A vector containing the user-defined colors for each alluvium.}

\item{cex}{Size of cluster number on block axis. Default if 0.7. See \link[alluvial]{alluvial}.}

\item{alpha}{Transparency of alluvia colors. Default is 0.3. See \link[alluvial]{alluvial}.}
}
\value{
An alluvial plot displaying comigrations and the data frame containing the input count_table with colors.
}
\description{
'draw_alluvial_plot' draw a alluvial plot
}
\examples{

# load XINA example data
data(xina_example)

# get a vector of experimental conditions analyzed in the clustering results
classes <- as.vector(example_clusters$condition)

comigrations_size_over5 <- alluvial_enriched(example_clusters, classes, comigration_size=5)
draw_alluvial_plot(example_clusters, classes, comigrations_size_over5)

}
