% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregulstions.R
\name{alluvial_enriched}
\alias{alluvial_enriched}
\title{alluvial_enriched}
\usage{
alluvial_enriched(clustering_result, selected_conditions,
  comigration_size = 0, pval_threshold = 1, pval_method = "fdr",
  cex = 0.7, alpha = 0.3)
}
\arguments{
\item{clustering_result}{A list containing XINA clustering results. See \link[XINA]{xina_clustering}}

\item{selected_conditions}{A vector of condition names used in XINA clustering results.
The number of selected conditions should be at least two.}

\item{comigration_size}{The number of proteins comigrated together in the selected conditions of XINA clustering results.
Default is 0}

\item{pval_threshold}{This option is avaiable only when you selected two conditions for comigration search.}

\item{pval_method}{Method for p-value adjustment. See \link[stats]{p.adjust}}

\item{cex}{Scaling of fonts of category labels. Default if 0.7. See \link[alluvial]{alluvial}}

\item{alpha}{Transparency of the stripes. Default if 0.3. See \link[alluvial]{alluvial}}
}
\value{
A data frame containing comigrations and an alluvial plot showing comigrations
}
\description{
'alluvial_enriched’ draws an alluvial plot and finds comigrated proteins.
The comigration is a group of proteins that show the same expression pattern,
classified and evaluated by XINA clustering, in at least two conditions.
XINA can reduce the dataset complexity by filtering based on
the number of comigrated proteins (size, ’comigration_size’ parameter) and
perform an enrichment test (P-value of Fisher’s exact test, ’pval_threshold’)
to determine significance of enriched comigrations.
The Fisher’s exact test can only be done for two conditions at a time.
The following 2x2 table was used to calculate the P-value from the Fisher’s exact test.
To evaluate significance of co-migrated proteins from cluster #1 in control to cluster #2 in test group,
     \tabular{rll}{
      - \tab cluster #1 in control \tab other clusters in control\cr
      cluster #2 in test      \tab 65 (TP) \tab 175 (FP)\cr
      other clusters in test  \tab 35 (FN) \tab 979 (TN)\cr
     }
}
\examples{

# load XINA example data
data(xina_example)

# Get the experimental conditions in the example data
classes <- as.vector(example_clusters$condition)

# Get comigrations without any thresholds
all_comigrations <- alluvial_enriched(example_clusters, classes)

# Get comigrations that have >= 5 size (the number of comigrated proteins)
all_cor_enriched <- alluvial_enriched(example_clusters, classes, comigration_size=5)

# Get all the comigrations between Control and Stimulus1
comigrations_Control_Stimulus1 <- alluvial_enriched(example_clusters,
c(classes[1],classes[2]))

# Get comigrations between Control and Stimulus1, that have >=5 size
comigrations_Control_Stimulus1_over5 <- alluvial_enriched(example_clusters,
c(classes[1],classes[2]), comigration_size=5)

# Get comigrations between Control and Stimulus1,
# that have >= 5 size and enrichment FDR <= 0.01
comigrations_Control_Stimulus1_pval0.01_size5 <- alluvial_enriched(example_clusters,
c(classes[1],classes[2]), comigration_size=5, pval_threshold=0.01)

# Get  comigrations between Control and Stimulus1,
# that have >= 5 size and enrichment Benjamini & Yekutieli <= 0.01
comigrations_Control_Stimulus1_BY0.01_size5 <- alluvial_enriched(example_clusters,
c(classes[1],classes[2]), comigration_size=5, pval_threshold=0.01, pval_method="BY")

}
