% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate-downstream.R
\name{clusterMoranPlot}
\alias{clusterMoranPlot}
\title{Find clusters on the Moran plot}
\usage{
clusterMoranPlot(
  sfe,
  features,
  BLUSPARAM,
  sample_id = "all",
  colGeometryName = NULL,
  annotGeometryName = NULL,
  swap_rownames = NULL
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object with Moran plot computed
for the feature of interest. If the Moran plot for that feature has not
been computed for that feature in this sample_id, it will be calculated and
stored in \code{rowData}. See \code{\link{calculateUnivariate}}.}

\item{features}{Features whose Moran plot are to be cluster. Features whose
Moran plots have not been computed will be skipped, with a warning.}

\item{BLUSPARAM}{A \linkS4class{BlusterParam} object specifying the algorithm to use.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{colGeometryName}{Name of colGeometry from which to look for features.}

\item{annotGeometryName}{Name of annotGeometry from which to look for
features.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}
}
\value{
A data frame each column of which is a factor for cluster
  membership of each feature. The column names are the features.
}
\description{
The Moran plot plots the value at each location on the x axis, and the
average of the neighbors of each locations on the y axis. Sometimes clusters
can be seen on the Moran plot, indicating different types of neighborhoods.
}
\examples{
library(SpatialFeatureExperiment)
library(SingleCellExperiment)
library(SFEData)
library(bluster)
sfe <- McKellarMuscleData("small")
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
# Compute moran plot
sfe <- runUnivariate(sfe,
    type = "moran.plot", features = rownames(sfe)[1],
    exprs_values = "counts"
)
clusts <- clusterMoranPlot(sfe, rownames(sfe)[1],
    BLUSPARAM = KmeansParam(2)
)
}
\concept{Downstream analyses of univariate spatial results}
