% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uset-plot.R
\name{upset_plot}
\alias{upset_plot}
\title{Create an UpSet plot for set intersection visualization}
\usage{
upset_plot(
  data_list,
  sets = NULL,
  min_intersection_size = 1,
  max_sets_display = NULL,
  sort_sets_by = "size",
  sort_sets_decreasing = TRUE,
  custom_sets_order = NULL,
  sort_intersections_by = "freq",
  sort_intersections_decreasing = TRUE,
  custom_intersections_order = NULL,
  intersection_color = "black",
  main_bar_color = "steelblue",
  sets_bar_colors = NULL,
  highlight_intersections = NULL,
  highlight_color = "darkorange",
  point_outline_color = "black",
  filled_point_size = 2,
  empty_point_size = 1.5,
  line_size = 0.5,
  bar_width = 0.6,
  point_stroke = 0.3,
  text_angle = 0,
  text_size = 10,
  set_text_size = 10,
  set_label_size = 3,
  intersection_label_size = 3,
  intersection_title = "Intersection Size",
  set_size_title = "Set Size",
  matrix_point_shape = 21,
  set_size_show_values = TRUE,
  intersection_size_show_values = TRUE,
  show_empty_intersections = FALSE,
  show_set_labels = TRUE,
  show_numbers_on_bars = TRUE,
  number_color_threshold = 0.75,
  number_colors = c(on_bar = "black", off_bar = "black"),
  plot_margin = 0.5,
  height_ratio = 0.5,
  width_ratio = 0.3,
  bar_offset = -0.01,
  theme_params = list(background_color = "white", grid_color = "grey92", axis_text_color
    = "black", use_grid = TRUE, border_color = NA),
  return_data = FALSE
)
}
\arguments{
\item{data_list}{A named list of vectors, each containing elements in a set}

\item{sets}{Optional vector of set names to include (default: all sets in data_list)}

\item{min_intersection_size}{Minimum intersection size to include (default: 1)}

\item{max_sets_display}{Maximum number of sets to display (default: all)}

\item{sort_sets_by}{How to sort the sets: "size", "name", or "custom" (default: "size")}

\item{sort_sets_decreasing}{Whether to sort sets in decreasing order (default: TRUE)}

\item{custom_sets_order}{Custom order for sets if sort_sets_by="custom"}

\item{sort_intersections_by}{How to sort intersections: "freq", "degree", or "custom" (default: "freq")}

\item{sort_intersections_decreasing}{Whether to sort intersections in decreasing order (default: TRUE)}

\item{custom_intersections_order}{Custom order for intersections if sort_intersections_by="custom"}

\item{intersection_color}{Color for intersection dots and lines (default: "black")}

\item{main_bar_color}{Color for the intersection size bars (default: "steelblue")}

\item{sets_bar_colors}{Named vector of colors for each set (default: auto-generated)}

\item{highlight_intersections}{Vector of intersection IDs to highlight (default: NULL)}

\item{highlight_color}{Color for highlighted intersections (default: "#FF5500")}

\item{point_outline_color}{Color for the outline of points (default: "black")}

\item{filled_point_size}{Size of filled points in the matrix (default: 2)}

\item{empty_point_size}{Size of empty points in the matrix (default: 1.5)}

\item{line_size}{Width of connecting lines (default: 0.5)}

\item{bar_width}{Width of bars (0-1 scale) (default: 0.7)}

\item{point_stroke}{Width of point outline (default: 0.3)}

\item{text_angle}{Angle for text labels (default: 0)}

\item{text_size}{Size of text in the plot (default: 10)}

\item{set_text_size}{Size of set labels (default: 10)}

\item{set_label_size}{Size of set size labels (default: 3)}

\item{intersection_label_size}{Size of intersection size labels (default: 3)}

\item{intersection_title}{Title for the intersection size plot (default: "Intersection Size")}

\item{set_size_title}{Title for the set size plot (default: "Set Size")}

\item{matrix_point_shape}{Shape of the dots in the matrix (21=filled circle) (default: 21)}

\item{set_size_show_values}{Whether to show set size values (default: TRUE)}

\item{intersection_size_show_values}{Whether to show intersection size values (default: TRUE)}

\item{show_empty_intersections}{Whether to show empty intersections (default: FALSE)}

\item{show_set_labels}{Whether to show set labels (default: TRUE)}

\item{show_numbers_on_bars}{Logical, whether to display counts on bars (default: TRUE)}

\item{number_color_threshold}{Fraction of max value where number color switches (default: 0.75)}

\item{number_colors}{Named vector with colors for labels on/off bars (default: c(on_bar="white", off_bar="black"))}

\item{plot_margin}{Margin around the plots in cm (default: 0.5)}

\item{height_ratio}{Ratio of matrix to total height (default: 0.7)}

\item{width_ratio}{Ratio of set size to total width (default: 0.3)}

\item{bar_offset}{Horizontal offset for top bars to improve alignment (default: 0)}

\item{theme_params}{List of theme parameters for customization (default: list of defaults)}

\item{return_data}{Whether to return the data along with the plot (default: FALSE)}
}
\value{
If return_data=FALSE, returns the patchwork plot object.
        If return_data=TRUE, returns a list containing the plot and component data.
}
\description{
Creates a custom UpSet plot showing the intersections between sets.
It displays the size of each intersection and the sets involved in each intersection.
}
\examples{
# Basic example
sets <- list(
  "Set A" = c(1:100),
  "Set B" = c(30:120),
  "Set C" = c(20:50, 90:110),
  "Set D" = c(10:40, 80:120)
)
upset_plot(sets, bar_offset = -0.02)

# With highlighting
upset_plot(sets,
          highlight_intersections = c(1, 2),
          highlight_color = "darkorange",
          bar_offset = -0.02)

# Custom colors
set_colors <- c("Set A" = "blue", "Set B" = "green",
               "Set C" = "orange", "Set D" = "purple")
upset_plot(sets, sets_bar_colors = set_colors,
          main_bar_color = "darkblue")
}
\author{
Kai Guo
}
