% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllGenerics.R,
%   R/methods-SnpDataFrame.R
\docType{class}
\name{SnpGRanges-class}
\alias{SnpGRanges-class}
\alias{SnpGRanges}
\alias{SnpGRanges,missing-method}
\alias{SnpGRanges,GRanges-method}
\title{An extension to GRanges for representing SNPs}
\usage{
SnpGRanges(object = GRanges(), isSnp, ...)

\S4method{SnpGRanges}{missing}(object, isSnp)

\S4method{SnpGRanges}{GRanges}(object, isSnp)
}
\arguments{
\item{object}{A \code{GRanges} object}

\item{isSnp}{A logical vector.  Each genomic interval in the
\code{GRanges} container corresponds to a marker on the genotyping
array.  \code{isSnp} is FALSE for nonpolymorphic markers such as
those included on the Affymetrix 6.0 chips.}

\item{...}{ignored}
}
\description{
An extension to GRanges for representing SNPs

Constructor for SnpGRanges class
}
\section{Slots}{

\describe{
\item{\code{elementMetadata}}{a \code{SnpDataFrame}}
}}

\examples{
SnpGRanges()
g <- GRanges("chr1", IRanges(15L, 15L))
SnpGRanges(g, isSnp=TRUE)
}
