% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateDiversity.R
\name{calculateDiversity}
\alias{calculateDiversity}
\alias{calculateDiversity,clonoStats-method}
\alias{calculateDiversity,SingleCellExperiment-method}
\title{Sample diversity estimation}
\usage{
calculateDiversity(x, ...)

\S4method{calculateDiversity}{clonoStats}(
  x,
  methods = c("all", "nCells", "nClonotypes", "shannon", "normentropy", "invsimpson",
    "ginisimpson", "chao1", "chaobunge"),
  ...
)

\S4method{calculateDiversity}{SingleCellExperiment}(x, ...)
}
\arguments{
\item{x}{A matrix of abundance values where rows are features (clonotypes)
and columns are samples. This is created with \code{summarizeClonotypes}
using a sparse matrix computed with either \code{EMquant} or
\code{CRquant}.}

\item{...}{Additional arguments passed to external calculation methods.}

\item{methods}{A character vector specifying which diversity measures to use
(default = \code{'all'}, see Details).}
}
\value{
A matrix of diversity estimates for each sample. Note that the
\code{'chaobunge'} method also includes an estimate of the standard error.
}
\description{
This function uses various methods to estimate the clonotypic
diversity of samples based on a matrix of clonotype abundances (samples are
columns).
}
\details{
Available methods are total cells with appropriate TCR data
(\code{'nCells'}, not a diversity measure, but a useful point of
comparison), total clonotypes (\code{'nClonotypes'}), Shannon entropy
(\code{'shannon'}), Simpson index (\code{'simpson'}), inverse Simpson index
(\code{'invsimpson'}), Chao1 richness (\code{'chao1'}), and Chao-Bunge
richness (\code{'chaobunge'}). A special value of \code{'all'} is also
allowed, which will run all methods listed above.

The \code{'chao1'} and \code{'chaobunge'} estimates assume all
abundances are integers. When this is not the case for the input matrix,
\code{k}, all values are multiplied by the \code{scaling_factor} and
rounded to the nearest integer. The resulting estimate is then divided by
\code{scaling_factor} to return to the original scale. The
\code{'shannon'}, \code{'simpson'}, and \code{'invsimpson'} methods work
with any input type.
}
\examples{
data('contigs')
x <- clonoStats(contigs)
calculateDiversity(x)

}
