% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addOr.R
\name{addOr}
\alias{addOr}
\title{Function to transform a large collapsed VCF into a dataframe,
incorporating predicted states along with the log-likelihood
ratio and p-value.}
\usage{
addOr(filtered_def_blocks_states, largeCollapsedVcf, hmm, genotypes)
}
\arguments{
\item{filtered_def_blocks_states}{data.frame object containing the blocks}

\item{largeCollapsedVcf}{Input VCF file}

\item{hmm}{Hidden Markov Model used to infer the events. The format should
adhere to the general HMM format from HMM package with a series of elements:
\enumerate{
\item The hidden states names in the "States" vector.
\item All possible observations in the "Symbols" vector.
\item Start probabilities of every hidden state in the "startProbs" vector.
\item Transition probabilities matrix of the hidden states in "transProbs".
\item Probabilities associated between every hidden state and all possible
observations in the "emissionProbs" matrix.
}}

\item{genotypes}{Possible GT formats and its correspondence with the hmm}
}
\value{
data.frame containing the transformed information.
}
\description{
Function to transform a large collapsed VCF into a dataframe,
incorporating predicted states along with the log-likelihood
ratio and p-value.
}
