% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendy.R
\name{trendy}
\alias{trendy}
\title{Trendy}
\usage{
trendy(Data = NULL, tVectIn = NULL, saveObject = FALSE,
  fileName = NULL, meanCut = 10, maxK = 3, minNumInSeg = 5,
  pvalCut = 0.1, numTry = 5, keepFit = FALSE, NCores = NULL,
  featureNames = NULL)
}
\arguments{
\item{Data}{a matrix of normalized expression measurements. Rows are 
genes/features and columns are samples.}

\item{tVectIn}{a numerical vector indicating the time-points or the 
order of samples. If it is NULL (default), then the time/order 
will be assumed to be equaly spaced from 1:N (N is number of samples).}

\item{saveObject}{if TRUE then the trendy object produced will be saved 
to use in the Shiny app (default is FALSE).}

\item{fileName}{the file name (and file path) to save the Trendy object, 
only used if saveObject=TRUE (default name is 
trendyOutputForShiny.RData).}

\item{meanCut}{genes whose mean is less than MeanCut will not be 
considered, default is 10.}

\item{maxK}{maximum number of breakpoints to consider. For each gene,
trendy will fit maxK + 1 models containing 0 -> maxK breakpoints
(1 -> (maxK + 1) segments). The model with the lowest BIC 
value will be selected (unless forceRsq = TRUE, see below).}

\item{minNumInSeg}{minimum number of samples required to be within 
a segment. If a breakpoint model has a segment with fewer than 
minNumInSeg point in any segment, then the model is not 
considered valid.}

\item{pvalCut}{p-value cutoff. If the p-value of a segment is greater than
PvalCut, then the segment will be called as 'no change'.}

\item{numTry}{the number of different seeds to try. If all numTry runs 
fail, then the linear regression (no breakpoints, one segment) model 
will be returned.}

\item{keepFit}{whether to report the fitted object (default is FALSE).}

\item{NCores}{number of cores to use, default is detectCores() - 1.}

\item{featureNames}{optional parameter to specify an explicit subset of 
features/genes to fit the segmented regression model to.}
}
\value{
Trend: direction of each sample; -1: down, 0: no change, 1: up
 Slope: fitted slopes, Slope.Trend: sign of fitted slopes, 
 Slope.Pvalue: p value of each segment, Breakpoint: estimated breakpoints, 
 Fitted.Values: fitted values AdjustedR2: adjusted R squared 
     value of the model
 Fit: fit object
}
\description{
Segmented regression models are fit for each gene. 
 The number of model fits is 1 -> maxK.
}
\examples{
 m1 <- matrix(c(c(rnorm(50,5,1),sort(rnorm(50, 15, 5))), rnorm(100, 50,10)), 2, 100, TRUE)
 rownames(m1) <- c("g1","g2")
 colnames(m1) <- paste0("time", seq_len(100))
 myTrends <- trendy(m1)
}
\author{
Ning Leng and Rhonda Bacher
}
